/* draw.c */ 

#include <stdio.h> 
#include <unistd.h> 
#include "consts.h" 
#include "draw.h" 

/* -------------------- Function Definitions -------------------- */

int DrawInitialModel( MPE_XGraph graph,
                      int my_rank,
                      int nrns_per_row,
                      int nrns_per_proc,
                      int radius,
                      int interval,
                      int shiftX,
                      int shiftY, 
		      int border,  
                      int vars_per_nrn,
                      double *data )
{
        int tmpX, tmpY;
        int bttn  = 2;


        if( my_rank == 0 )
        {
                printf( "\n\nDrawing neuron model for timestep 0\n" );
                printf( "Please wait ... \n" );
        }

        /* Draw the model of the 1st timestep many times to make
         * sure that all neurons are drawn properly. If they are
         * drawn only once, there will be some blank spots and the
         * model will not be complete.
         */
        DrawNeuronModel( my_rank,
                         nrns_per_row,
                         nrns_per_proc,
                         radius,
                         interval,
                         shiftX,
                         shiftY, 
			 border,
                         data,
                         graph,
                         vars_per_nrn );

        MPI_Barrier( MPI_COMM_WORLD );
        MPE_Update( graph );

        sleep( 1 );   /* for some unknown reasons this is necessary */

        while( bttn == 2 )
        {
                DrawNeuronModel( my_rank,
                                 nrns_per_row,
                                 nrns_per_proc,
                                 radius,
                                 interval,
                                 shiftX,
                                 shiftY,
				 border, 
                                 data,
                                 graph,
                                 vars_per_nrn );
                MPI_Barrier( MPI_COMM_WORLD );
                MPE_Update( graph );

                if( my_rank == 0 )
                {
                        printf( "\nClick left button for next timestep\n" );
                        printf( "(or middle button to redraw the model)\n\n" );


                        MPE_Get_mouse_press( graph, &tmpX, &tmpY, &bttn );
                }
                MPI_Barrier( MPI_COMM_WORLD );
                MPI_Bcast( &bttn, 1, MPI_INT, 0, MPI_COMM_WORLD );

        } /* end of while */


        return 1;
}

int DrawNeuronModel( int        my_rank,
                     int        nrns_per_row,
                     int        nrns_per_proc,
                     int        r,
                     int        interval,
                     int        shiftX,
                     int        shiftY,
		     int        border, 
                     double     *data,
                     MPE_XGraph graph,
                     int        vars_per_nrn )
{
        int i;
	int id; 
	int x; 
	int y; 
	int color;  

        for( i = 0; i < nrns_per_proc; i++ )
        {
	   /* determine neuron id */ 
	   id = my_rank*nrns_per_proc + i;  

	   /* calculate neuron coordinates */ 
	   x = border + shiftX + r + ( id%nrns_per_row )*( 2*r + interval );  
	   y = border + shiftY + r + ( id/nrns_per_row )*( 2*r + interval );  

	   /* determine neuron color */ 
	   if( data[ i*vars_per_nrn + VOLTAGE ] > THRESHOLD ) 
	      color = WHITE; 
	   else 
	      color = BLUE;  

           DrawNeuron( x, y, r, color, graph );
        }

        return 1;
}

int DrawNeuron( int x, int y, int r, int color, MPE_XGraph graph )
{
        if( r < 1 )
                return MPE_Draw_point( graph, x, y, (MPE_Color)color );

        return MPE_Fill_circle( graph, x, y, r, (MPE_Color)color );
}

/* -------------------------------------------------------------- */
