/* draw.h */ 

#ifndef DRAWND_H 
#define DRAWND_H 

#include "mpi.h" 
#include "mpe.h" 
#include "mpe_graphics.h" 


/* -------------------- function prototypes -------------------- */

int DrawInitialModel( MPE_XGraph graph,
                      int        my_rank,
                      int        nrns_per_row,
                      int        nrns_per_col,
                      int        radius,
                      int        interval,
                      int        shiftX,
                      int        shiftY,
		      int        border, 
                      int        vars_per_nrn,
                      double     *data         );

int DrawNeuronModel(  int        my_rank,
                      int        nrns_per_row,
                      int        nrns_per_proc,
                      int        r,
                      int        interval,
                      int        shiftX,
                      int        shiftY,
		      int        border, 
                      double     *data,
                      MPE_XGraph graph,
                      int        vars_per_nrn );

int DrawNeuron(       int        x,
                      int        y,
                      int        r,
                      int        color,
                      MPE_XGraph graph );

/* ----------------------------------------------------------------- */

#endif 

