/* fileio.c --- file I/O for Neuron Display functions */ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mpi.h" 
#include "fileio.h" 

/* ---------------------------------------------------------------------- */
/* Function Defined */

int ReadDataTXT( FILE   *fp, 
                 double *data_CTP, 
                 int    *timestep, 
                 int    total_timesteps, 
                 int    display_freq, 
                 int    vars_per_proc ) 
{ 
	int i, j; 
	int loop; 

	loop = 1; 
	if( (*timestep) == 0 || display_freq == 1 ) 
		(*timestep)++; 
	else   /* (*timestep) > 0 */ 
	{ 
		(*timestep) = (*timestep) + display_freq; 
		if( (*timestep) - 1 >= total_timesteps ) 
			return INVALID; 
		loop = display_freq; 
	} 

	for( i = 0; i < loop; i++ ) 
		for( j = 0; j < vars_per_proc; j++ ) 
			fscanf( fp, "%lf", &( data_CTP[ j ] ) ); 

	return VALID; 
} 

int ReadDataBIN( FILE   *fp, 
                 double *data_CTP, 
                 int    *timestep, 
                 int    total_timesteps, 
                 int    display_freq, 
                 int    vars_per_proc   )  
{ 
	if( (*timestep) == 0 || display_freq == 1 ) 
		(*timestep)++; 
	else 
	{ 
		long dist; 
 
                (*timestep) = (*timestep) + display_freq;
                if( (*timestep) - 1 >= total_timesteps )
                        return INVALID;

		dist = (long)( sizeof( double )*vars_per_proc*( display_freq - 1 ) ); 
		fseek( fp, dist, SEEK_CUR );  
	} 

	fread( data_CTP, sizeof( double ), vars_per_proc, fp ); 

	return VALID; 
} 

FILE* OpenFile( char* filename, char* mode ) 
{ 
        FILE* fp = fopen( filename, mode ); 

        if( fp == NULL ) 
        { 
                fprintf( stderr, "\nCannot open %s!\n", filename ); 
                fprintf( stderr, "Aborting!\n" ); 
                fflush( stderr ); 
                MPI_Abort( MPI_COMM_WORLD, 1 ); 
                exit( 1 ); 
        } 

        return fp; 
} 

void NameFile( char* root, int n, int ftype, char* fname ) 
{ 
   int i, j; 
   char tmp[ MAXEXT ]; 
   char ext[ MAXEXT ]; 

   i = 0; 
   do 
   { 
      tmp[ i++ ] = n%10 + '0'; 
      n = n/10; 
   } while( n != 0 ); 
   tmp[ i ] = '.'; 

   for( j = 0; i >= 0; i--, j++ ) 
      ext[ j ] = tmp[ i ]; 
   ext[ j ] = '\0'; 

   strcpy( fname, root ); 
   strcat( fname, ext ); 

   if( ftype == BINARY ) 
      strcat( fname, "b" ); 
}

/* ----------------------------------------------------------------------*/ 
