 /*
  * neurondiz.c
  *   written by Mathlab 1997-1998, University of San Francisco
  * -------------------------------------------------------------------
  */
 
#include <stdio.h>
#include <stdlib.h>	   /* calloc is used */
#include <unistd.h>
#include <string.h>
#include "mpi.h"
#include "mpe.h"	   /* used for mpe   */
#include "mpe_graphics.h"  /* used for mpe   */

#include "consts.h" 
#include "fileio.h" 
#include "ui.h" 
#include "setup.h" 
#include "draw.h" 


/* ----------------------- main starts here ----------------------- */

int main( int argc, char *argv[] )  {  

    /* MPI related variables */
    int total_processes; 
    int my_rank;

    /* Neuron data parameters */
    unsigned int total_neurons; 

    int neurons_per_row; 
    int neurons_per_col; 
    int vars_per_neuron;  
    int total_timesteps; 
    int display_freq;  
    int variables_per_process;
    int neurons_per_process;

    double *data_CTP; 
    /*double *data_ptr;*/  

    /* I/O related variables */
    FILE *fp;
    int ftype; 
    char fname_root[ MAXFNAME ]; 
    char fname_whole[ MAXFNAME ]; 
 
    /* Temp variable */ 
    int valid_data; 
 
    /* variables used for MPE */
    MPE_XGraph graph;
    int winX, winY, winW, winH;
    int timestep; 
    int radius; 
    int interval; 
    int border; 
    int shiftX, shiftY;  
#   ifdef CLICK_STEP
    int posX, posY; 
    int button;  
#   endif

    /* ----- Initializations ----- */
    MPI_Init( &argc, &argv );
    MPI_Comm_rank( MPI_COMM_WORLD, &my_rank );
    MPI_Comm_size( MPI_COMM_WORLD, &total_processes );


    /* ----- Reading resource information ----- */ 
    if ( my_rank == 0 ) { 
        ReadResource( &neurons_per_row, &neurons_per_col, 
                      &vars_per_neuron, &total_timesteps, 
                      &display_freq, 
		      &ftype, fname_root     );  
    } /* end of if */

    /* Notify all process about the new values read in by P0 */
    MPI_Bcast( &neurons_per_row,  1, MPI_INT,  0, MPI_COMM_WORLD ); 
    MPI_Bcast( &neurons_per_col,  1, MPI_INT,  0, MPI_COMM_WORLD );
    MPI_Bcast( &vars_per_neuron,  1, MPI_INT,  0, MPI_COMM_WORLD );
    MPI_Bcast( &total_timesteps,  1, MPI_INT,  0, MPI_COMM_WORLD );
    MPI_Bcast( &display_freq,     1, MPI_INT,  0, MPI_COMM_WORLD ); 
    MPI_Bcast( &ftype,            1, MPI_INT,  0, MPI_COMM_WORLD ); 
    MPI_Bcast( fname_root, MAXFNAME, MPI_CHAR, 0, MPI_COMM_WORLD ); 


    /* ----- Graphics Initializations ----- */
    winX = UPPERX;
    winY = UPPERY; 

    SetUpDisplay( neurons_per_row, neurons_per_col, 
                  &radius, &interval, &border, 
                  &shiftX, &shiftY, &winW, &winH ); 
 
    InitGraph( &graph, my_rank, winX, winY, winW, winH );


    /* ----- Variable initialization ----- */
    total_neurons          = neurons_per_row*neurons_per_col; 
    neurons_per_process    = total_neurons/total_processes;
    variables_per_process  = neurons_per_process*vars_per_neuron;

    /*  If there's a timestep in the input file:
     *  variables_per_process  = neurons_per_process*vars_per_neuron+1;
     */
    timestep = 0; 

    /* Allocating appropriate memory storage for all the neurons
     * assigned to this process. 
     */
    data_CTP = (double*)malloc( sizeof(double)*variables_per_process ); 
    /*data_ptr = &( data_CTP[ 1 ] );*/   

    NameFile( fname_root, my_rank, ftype, fname_whole ); 
    fp = OpenFile( fname_whole, READONLY ); 


    /* ---- Drawing the neuron model in the first timestep ---- */ 

    MPE_Fill_rectangle ( graph, winX, winY, winW, winH, 
    		     MPE_BLACK );   /* black background */ 

    if( ftype == TEXT ) 
        ReadDataTXT( fp, data_CTP, &timestep, total_timesteps, 
		     display_freq, variables_per_process ); 
    else 
        ReadDataBIN( fp, data_CTP, &timestep, total_timesteps, 
		     display_freq, variables_per_process );  

    DrawInitialModel( graph, my_rank, neurons_per_row, 
                 neurons_per_process, radius, interval, 
                 shiftX, shiftY, border, vars_per_neuron, 
                 data_CTP ); 


    /* ----- Drawing the 1st timestep model ends ----- */ 
  

    /* Synchronize processes to go into next time steps */ 
    MPI_Barrier( MPI_COMM_WORLD );  

    for( timestep = 1; timestep < total_timesteps; ) { 
        if( ftype == TEXT ) 	
            valid_data = ReadDataTXT( fp, data_CTP, &timestep, 
				      total_timesteps, display_freq, 
				      variables_per_process ); 
	else 
	    valid_data = ReadDataBIN( fp, data_CTP, &timestep, 
				      total_timesteps, display_freq, 
				      variables_per_process );  

    	if( valid_data ) { 
            if( my_rank == 0 )
                printf( "Drawing model for timestep %d\n", 
                            ( timestep - 1 ) );  

    	    DrawNeuronModel( my_rank, neurons_per_row,  
                             neurons_per_process, radius, 
    			     interval, shiftX, shiftY, border,  
    			     data_CTP, graph,
    			     vars_per_neuron ); 
    	    MPE_Update( graph ); 

#           ifdef CLICK_STEP
            if (my_rank == 0) 
    	        MPE_Get_mouse_press(graph, &posX, &posY, &button); 
#           else
            sleep(SLEEP_INTERVAL);
#           endif

    	    /* This MPI_Barrier is necessary in order to make other 
    	     * processes wait while process 0 waits for mouse click.
    	     */ 
    	    MPI_Barrier( MPI_COMM_WORLD ); 

    	}   /* end of if valid_data*/  
    } /*end of for */    

    if( my_rank == 0 ) {
        printf( "\nSimulation over!\n\n" );  
    }


    /* ---------- Clear things up before quitting ---------- */

    
    MPE_Close_graphics( &graph ); 
    free( data_CTP );
    fclose( fp );

    MPI_Finalize();  /* Shut down MPI */ 

    return 0;
} /* end of main */
 

/* -------------------------------------------------------------- */ 

