/* ui.c --- user interface for Neuron Display functions */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mpi.h"
#include "fileio.h"
#include "ui.h"

/*----------------------------------------------------------------------*/
/* Function Defined */

int ReadResource( int  *neurons_per_row, 
                  int  *neurons_per_col, 
                  int  *vars_per_neuron, 
                  int  *total_timesteps, 
                  int  *display_freq, 
		  int  *ftype, 
		  char *fname            ) 
{
        char sel; 
        char clearCR; 
	char **info_strings; 

	sel = GetInputMode(); 
        if( sel == 'a' ) 
		info_strings = PromptUser(); 
        else if( sel == 'b' || sel == 'c' ) 
        { 
		strcpy( fname, NEURONRC ); 
                if( sel == 'c' ) 
                { 
                        printf( "Specify filename: " ); 
                        scanf( "%s", fname ); 
                        scanf( "%c", &clearCR ); 
                } 
		info_strings = ReadResourceFile( fname ); 
        } 
        else 
        { 
                fprintf( stderr, "\nInvalid input.\n" ); 
                fprintf( stderr, "Aborting!!!\n\n" ); 
                fflush( stderr ); 
                MPI_Abort( MPI_COMM_WORLD, 1 ); 
                exit( 1 ); 
        } 

	CheckInfoStrings( info_strings ); 
	ConvertDataFormat( info_strings, 
			   neurons_per_row, 
			   neurons_per_col, 
			   vars_per_neuron, 
			   total_timesteps, 
			   display_freq, 
			   ftype, 
			   fname            ); 
	DeleteStrings( info_strings ); 

        return 1; 
} 

/*----------------------------------------------------------------------*/ 
char GetInputMode( void ) 
{ 
	char key; 
	char clearCR; 

        printf( "\nInput resource info\n" );
        printf( "     a) manually\n" );
        printf( "     b) from neuron.rc\n" );
        printf( "     c) from another file\n" );
        printf( "Selection: " );
        scanf( "%c", &key );
        scanf( "%c", &clearCR );

	return key; 
} 

/*----------------------------------------------------------------------*/ 
char** PromptUser( void )
{ 
	int    i; 
	char   clearCR; 
	char** strings; 

	strings = (char**)malloc( NUMSTRS*sizeof( char* ) ); 
	for( i = 0; i < ( NUMSTRS - 1 ); i++ ) 
		strings[ i ] = (char*)malloc( MAXDGT*sizeof( char ) ); 
	strings[ NUMSTRS - 1 ] = (char*)malloc( MAXSTR*sizeof( char ) ); 

	printf( "\n" ); 
	printf( "columns of neurons: " ); 
	scanf( "%s", strings[ 0 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "rows of neurons: " ); 
	scanf( "%s", strings[ 1 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "variables per neuron : " ); 
	scanf( "%s", strings[ 2 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "total timesteps : " ); 
	scanf( "%s", strings[ 3 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "display frequency : " ); 
	scanf( "%s", strings[ 4 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "data file type (txt or bin) : " ); 
	scanf( "%s", strings[ 5 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "data file name (without ext) : " ); 
	scanf( "%s", strings[ 6 ] ); 
	scanf( "%c", &clearCR ); 
	printf( "\n" ); 

	return strings; 
} 

/*----------------------------------------------------------------------*/ 
char** ReadResourceFile( char *fname ) 
{ 
	int    i; 
	FILE*  fp; 
	char*  str; 
	char** strings; 

	strings = (char**)malloc( NUMSTRS*sizeof( char* ) ); 
        fp = OpenFile( fname, READONLY ); 
	str = GetString( fp ); 
	for( i = 0; str != NULL && i < NUMSTRS; i++ ) 
	{ 
		strings[ i ] = str; 
		str = GetString( fp ); 
	} 
	fclose( fp ); 

	if( i < NUMSTRS ) 
	{ 
		fprintf( stderr, "\nInsufficient info " ); 
		fprintf( stderr, "in \"%s\".\n", fname ); 
		fprintf( stderr, "Aborting!!!\n\n" ); 
		fflush( stderr ); 
		DeleteStrings( strings ); 
                MPI_Abort( MPI_COMM_WORLD, 1 );
		exit( 1 ); 
	} 

	return strings; 
} 

/*----------------------------------------------------------------------*/
char* GetString( FILE* fp ) 
{ 
   int i; 
   char c; 
   char tmp[ MAXSTR ]; 
   char* str = NULL; 

   if( feof( fp ) ) 
      return NULL; 

   c = getc( fp ); 
   while( !feof( fp ) && isspace( c ) ) 
      c = getc( fp ); 

   if( feof( fp ) ) 
      return NULL; 

   i = 0; 
   while( !feof( fp ) && !isspace( c ) && i < MAXSTR ) 
   { 
      tmp[ i++ ] = c; 
      c = getc( fp ); 
   } 

   if( i == MAXSTR ) 
      i--; 
   tmp[ i ] = '\0'; 
   str = (char*)malloc( i + 1 ); 
   strcpy( str, tmp ); 

   return str; 
} 

/*----------------------------------------------------------------------*/ 
void CheckInfoStrings( char** info ) 
{ 
	int i; 
	char tmp[ MAXSTR ]; 

	for( i = 0; i < ( NUMSTRS - NONINTS ); i++ ) 
	{ 
		if( !IsInt( info[ i ] ) ) 
		{ 
			fprintf( stderr, "\nInvalid input : " ); 
			fprintf( stderr, "%s.\n", info[ i ] ); 
			fprintf( stderr, "Aborting!!!\n\n" ); 
			fflush( stderr ); 
			DeleteStrings( info ); 
			MPI_Abort( MPI_COMM_WORLD, 1 ); 
			exit( 1 ); 
		} 
	} 

	strcpy( tmp, info[ NUMSTRS - NONINTS ] ); 
	for( i = 0; tmp[ i ] != '\0'; i++ ) 
		tmp[ i ] = tolower( tmp[ i ] ); 
	if( strcmp( tmp, TXT ) == 0 || strcmp( tmp, BIN ) == 0 ) 
		strcpy( info[ NUMSTRS - NONINTS ], tmp ); 
	else 
	{ 
		fprintf( stderr, "\nInvalid input : " ); 
		fprintf( stderr, "%s\n", info[ NUMSTRS - NONINTS ] );
                fprintf( stderr, "Aborting!!!\n\n" );
                fflush( stderr ); 
		DeleteStrings( info ); 
                MPI_Abort( MPI_COMM_WORLD, 1 );
                exit( 1 );
	} 
} 

/*----------------------------------------------------------------------*/ 
int IsInt( char* str ) 
{ 
   int i; 

   if( str[ 0 ] == '\0' || str[ 0 ] == '0' ) 
      return 0; 

   for( i = 0; str[ i ] != '\0'; i++ ) 
      if( !isdigit( str[ i ] ) ) 
         return 0; 

   return 1; 
} 

/*-------------------------------------------------------------------*/ 
void ConvertDataFormat( char **strings, 
			int  *neurons_per_row, 
			int  *neurons_per_col, 
			int  *vars_per_neuron, 
			int  *total_timesteps, 
			int  *display_freq, 
			int  *ftype, 
			char *fname            ) 
{ 
	(*neurons_per_row) = atoi( strings[ 0 ] ); 
	(*neurons_per_col) = atoi( strings[ 1 ] ); 
	(*vars_per_neuron) = atoi( strings[ 2 ] ); 
	(*total_timesteps) = atoi( strings[ 3 ] ); 
	(*display_freq)    = atoi( strings[ 4 ] ); 

	if( strcmp( strings[ 5 ], BIN ) == 0 ) 
		(*ftype) = BINARY; 
	else 
		(*ftype) = TEXT; 

	strcpy( fname, strings[ 6 ] ); 
} 

/*-------------------------------------------------------------------*/ 
void DeleteStrings( char** str ) 
{ 
	int  i; 

	for( i = 0; i < NUMSTRS; i++ ) 
		free( str[ i ] ); 
	free( str ); 
} 

/*----------------------------------------------------------------------*/ 

