/*
 * globals.h
 */
#ifndef GLOBALS_H
#define GLOBALS_H

#include "mpi.h"
#include "equations.h"

extern int my_rank;
extern int num_processes;
extern MPI_Comm comm;

extern int num_steps;
extern int num_my_equations;
extern int my_first_var;
extern int my_last_var;
extern int total_equations;  
extern int num_my_neurons;
extern int my_first_neuron;
extern int my_last_neuron;
extern int total_neurons;
extern int row_count;
extern int col_count;

extern double time_init;
extern double step_size;

extern int print_freq;
extern char output_filename[];

extern int* neuron_types;
extern syn_conn_t* syn_connections;

#endif
