/*
 * input.h 
 */

#ifndef INPUT_H
#define INPUT_H	

#include "equations.h"
#include "utility.h"

void Read_data(
         double**      y_init              /* OUT */,
         double**      syn_init            /* OUT */);

void Open_input_file(
         FILE**  fp            /* OUT */,
         bool*   print_prompt  /* OUT */);

void Get_scalar_input(
         bool     print_prompt     /* IN  */,
         FILE*    fp               /* IN  */);

void Get_neuron_types(
         FILE*  fp             /* IN  */,
         bool   print_prompt   /* IN  */);

void Get_y_init (
         bool     print_prompt     /* IN  */,
         FILE*    fp               /* IN  */,
         double   y_init[]         /* OUT */,
         double   syn_init[]       /* OUT */);

void Get_syn_info(
         FILE*       fp                 /* IN  */);

void Get_dimensions(
         FILE*  fp                  /* IN  */,
         int    temp_dimension[]    /* OUT */,
         int    my_dimensions[]     /* OUT */,
         int*   max_dim             /* OUT */);

void Get_links_and_types(
         int         max_dim          /* IN  */,
         int         temp_dimension[] /* IN  */,
         int         my_dimensions[]  /* IN  */,
         FILE*       fp               /* IN  */);

void Compute_my_params(void);

void Skip_white_space(void);
#endif
