/* 
 * prof.c
 *
 * Handles profiling.  With "totals only" profiling, these routines
 *    can be used with any MPI implementation.  Other forms of
 *    profiling require the mpich implementation and the mpe 
 *    extensions 
 */
#include "prof.h"
#include "mpi.h"
#include <stdio.h>
/*
#include "mpe.h"
*/

double all_gather_time;
double calc_time;
double output_time;
double gather_time;
double total_time;
double total_start;
double start;
int print_count;

/*================================================================*/
void Setup_profiling(void) {
/*
    int my_rank;

    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
    MPI_Pcontrol(1);

    if (my_rank == 0) {
        MPE_Describe_state(START_OUTPUT, FINISH_OUTPUT, 
            "Output", "red");
        MPE_Describe_state(START_ALL_GATHER, FINISH_ALL_GATHER, 
            "All_gather", "white");
        MPE_Describe_state(START_CALC, FINISH_CALC,
            "Calc", "blue");
        MPE_Describe_state(START_GATHER, FINISH_GATHER, 
            "Gather", "green");
    }
*/
    all_gather_time = 0.0;
    calc_time = 0.0;
    output_time = 0.0;
    gather_time = 0.0;
    total_time = 0.0;
    print_count = 0;

    total_start = MPI_Wtime();

}  /* Setup_profiling */


/*================================================================*/
void Finish_profiling(void) {
    double other_time;
    int my_rank;

    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
/*
    MPE_Finish_log("solver");
    MPI_Pcontrol(0);
*/
    total_time = MPI_Wtime() - total_start;
    other_time = total_time - 
         (all_gather_time + calc_time + output_time+ gather_time);
    if (my_rank == 0) {
        printf("Process All_gath   Calc    Output   Gather");
        printf("   Total    Other   Prt_out\n");
        printf("------- -------- -------- -------- --------");
        printf(" -------- -------- --------\n");
    }
    printf("   %2d   %6.1f   %6.1f   %6.1f   %6.1f   %6.1f   %6.1f   %5d\n",
        my_rank, all_gather_time, calc_time, output_time, gather_time,
        total_time, other_time, print_count);
}  /* Finish_profiling */


/*================================================================*/
void Start_output_prof(void) {
/*
    MPE_Log_event(START_OUTPUT, 0, "Start output");
*/
    start = MPI_Wtime();
}  /* Start_output_prof */


/*================================================================*/
void Finish_output_prof(void) {
/*
    MPE_Log_event(FINISH_OUTPUT, 0, "Finish output");
*/
    output_time += (MPI_Wtime() - start);
}  /* Finish_output_prof */


/*================================================================*/
void Start_all_gather_prof(void) {
/*
    MPE_Log_event(START_ALL_GATHER, 0, "Start all_gather");
*/
    start = MPI_Wtime();
}  /* Start_all_gather_prof */


/*================================================================*/
void Finish_all_gather_prof(void) {
/*
    MPE_Log_event(FINISH_ALL_GATHER, 0, "Finish all_gather");
*/
    all_gather_time += (MPI_Wtime() - start);
}  /* Finish_all_gather_prof */


/*================================================================*/
void Start_calc_prof(void) {
/*
    MPE_Log_event(START_CALC, 0, "Start calc");
*/
    start = MPI_Wtime();
}  /* Start_calc_prof */

/*================================================================*/
void Finish_calc_prof(void) {
/*
    MPE_Log_event(FINISH_CALC, 0, "Finish calc");
*/
    calc_time += (MPI_Wtime() - start);
}  /* Finish_calc_prof */


/*================================================================*/
void Start_gather_prof(void) {
/*
    MPE_Log_event(START_GATHER, 0, "Start gather");
*/
    start = MPI_Wtime();
}  /* Start_gather_prof */

/*================================================================*/
void Finish_gather_prof(void) {
/*
    MPE_Log_event(FINISH_GATHER, 0, "Finish gather");
*/
    gather_time += (MPI_Wtime() - start);
}  /* Finish_gather_prof */
