/* 
 * read_constants.t
 *
 * Template for read_constants.c 
 * Used by create_build_constants.c to create the C source file
 *    build_constants.c
 * The dollar signs ($) indicate where text should be added
 */
/* read_constants.c
 *
 * reads the constants used in the equations modelling the neurons.
 */
#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"
#include "equations.h"
#include "read_constants.h"
#include "utility.h"
#include "nscanf.h"
#include "globals.h"

void Build_constants_mpi_type(
         MPI_Datatype*  constants_mpi_t  /* OUT */) {

    int            total_count;
    int            i;

    /* Arguments to MPI_Type_struct */
    int*           block_lengths;
    MPI_Aint*      displacements;
    MPI_Datatype*  typelist;

    /* Use for calculating displacements */
    MPI_Aint       start_address;
    MPI_Aint       address;

    total_count = INT_COUNT + DOUBLE_COUNT;
    block_lengths = (int*) malloc(total_count*sizeof(int));
    Check_malloc(block_lengths, 
                 "block_lengths in Build_constants_mpi_type");
    displacements = (MPI_Aint*) malloc(total_count*sizeof(MPI_Aint));
    Check_malloc(block_lengths, 
                 "displacements in Build_constants_mpi_type"); 
    typelist = (MPI_Datatype*) malloc(total_count*sizeof(MPI_Datatype));
    Check_malloc(block_lengths, "typelist in Build_constants_mpi_type"); 

    /* Assumes each input constant is a scalar */
    for (i = 0; i < total_count; i++)
        block_lengths[i] = 1;

    /* The first INT_COUNT input constants are ints */
    for (i = 0; i < INT_COUNT; i++)
        typelist[i] = MPI_INT;

    /* The remaining DOUBLE_COUNT constants are doubles */
    for (i = INT_COUNT; i < total_count; i++)
        typelist[i] = MPI_DOUBLE;

    /* Get the displacements by hands */
    displacements[0] = 0;

    MPI_Address(&$, &start_address);  /* First constant */

    /* Add in a sequence of pairs of statements having the form
     * MPI_Address(&CONSTANT, &address);        
     * displacements[i] = address - start_address;
     */
    $
    
    MPI_Type_struct(total_count, block_lengths, displacements,
        typelist, constants_mpi_t);
    MPI_Type_commit(constants_mpi_t);

    free(block_lengths);
    free(displacements);
    free(typelist);

}  /* Build_constants_mpi_type */


/*==================================================================*/
void Read_constants(void) {

    char          filename[MAX_NAME];
    FILE*         fp;
    MPI_Datatype  constants_mpi_t;

    Build_constants_mpi_type(&constants_mpi_t);
    

    /* Process 0 gets the input data */
    if (my_rank == 0) {
        
        printf("What's the file name for constants?\n");
        nscanf(stdin, "%s", filename);
        fp = fopen(filename,"r");

        if (!fp) {
            fprintf(stderr,
                "Process 0 > Attempt to open %s failed.\n", filename);
            fflush(stderr);
            MPI_Abort(MPI_COMM_WORLD, -1);
        }
        
        /* Add a sequence of statements having the form
         * nscanf(fp, "%d" or "%lf", &CONSTANT);
         */

        $

        fclose(fp);
    }  /* my_rank == 0 */
    
    /* Add MPI_Bcast 
     * First arg should be first constant 
     * MPI_Bcast(&CONSTANT, 1, constants_mpi_t, 0, MPI_COMM_WORLD);
     */

    $

#ifdef DEBUG
    /* Add printfs showing input values 
     * printf("Process %d > CONSTANT = %f\n", my_rank, CONSTANT);
     */
    $

    fflush(stdout);
#endif

    MPI_Type_free(&constants_mpi_t);

}  /* Read_constants */

