/*
 * equations.h
 */

#ifndef EQUATIONS_H
#define EQUATIONS_H

#include "mpi.h"
#include "comm.h"

/*
 * Parameters needed to specify the equations modelling the neuron.
 * These are defined in equations.c.
 */

/* This macro defines how synaptic currents are exchanged among
 * neurons belonging to different processes.  Current possible
 * values:
 *
 *     1.  MPI_Allgather:  use this if there are synaptic connections
 *         between arbitrary neurons.
 *     2.  Pairwise_exchange:  use this if there are only synaptic
 *         connections between neurons assigned to adjacent processes
 *         and buffers are contiguous.
 */
#define ALL_GATHER MPI_Allgather
/* #define ALL_GATHER Pairwise_exchange */

/* Number of input int constants */
#define INT_COUNT 0
/* Number of input double constants */
#define DOUBLE_COUNT 10

/* List of input constants from equations.c */
extern double 
    I_APP,
    G_NA,
    G_K,
    G_L,
    V_NA,
    V_K,
    V_L,
    V_S,
    G_S,
    TAU_S;

/* Stores information about synaptic connections */
/* Shouldn't need to be changed                  */
typedef struct { 
    int dimension; 
    int* links; 
    int* signs; /* added for connection types */
} syn_conn_t;

/* Make this data available to other parts of the program */
/* Shouldn't need modification                            */
extern int      MODEL_COUNT;
extern int      EQUATION_COUNTS[];
extern int      VOLTAGE_EQN_OFFSETS[];
extern int      SYNAPTIC_EQN_OFFSETS[];

/* Modify these prototypes to agree with your model.  If you */
/* change the argument lists for Setup_f, Compute_f, or      */
/* Cleanup_f, you'll need to change the calls in the solver  */
void Setup_f(void);

void Compute_f(
         double       y[]               /* IN  */,
         double       syn_output[]      /* IN  */,
         double       answer[]          /* OUT */,
         double       syn_answer[]      /* OUT */);

void Compute_V_prime(
         double       y[]                /* IN  */,
         double       answer[]           /* OUT */,
         double       syn_output[]       /* IN  */,
         int          i                  /* IN  */,
         int          neuron             /* IN  */);

void Compute_h_prime(
         double   y[]       /* IN  */,
         double   answer[]  /* OUT */,
         int      i         /* IN  */);

void Compute_n_prime(
         double       y[]                /* IN  */,
         double       answer[]           /* OUT */,
         int          i                  /* IN  */);

void Compute_s_prime(
         double   y[]                 /* IN  */,
         double   syn_output[]        /* IN  */,
         double   syn_answer[]        /* OUT */,
         int      i                   /* IN  */,
         int      neuron              /* IN  */,
         int      global_neuron_rank  /* IN  */);

void Cleanup_f(void);
#endif
