/* 
 * utility.c 
 *
 * General utility functions
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mpi.h"
#include "utility.h"


#define COMMENT_CHAR '#'
#define MAX_LINE 256
char line_buf[MAX_LINE];
static double* global = (double*) NULL;

/*================================================================*/
void Print_local_vector(
         char      title[]            /* IN */,
         double    vect[]             /* IN */,
         int       num_equations      /* IN */,
         int       my_rank            /* IN */) {
    int i;

    printf("    %s\n", title);

    printf("Process %d > ", my_rank);
    for (i = 0; i < num_equations; i++)
        printf("%f ", vect[i]);
    printf("\n");
    fflush(stdout);
}  /* Print_local_vector */


/*================================================================*/
void Print_local_int_vector(
         char      title[]    /* IN */,
         int       vect[]     /* IN */,
         int       order      /* IN */,
         int       my_rank    /* IN */) {

    int i;

    printf("    %s\n", title);

    printf("Process %d > ", my_rank);
    for (i = 0; i < order; i++)
        printf("%d ", vect[i]);
    printf("\n");
    fflush(stdout);
}  /* Print_local_int_vector */


/*================================================================*/
void Print_global_vector(
         char      title[]            /* IN */,
         double    vect[]             /* IN */,
         int       local_equations    /* IN */,
         int       global_equations   /* IN */,
         int       my_rank            /* IN */) {

    static int first_time = 1;

    if (first_time && (my_rank == 0)) {
        global = (double*) malloc(global_equations*sizeof(double));
        Check_malloc(global, "global"); 
        first_time = 0;
    }

    MPI_Gather (vect,   local_equations, MPI_DOUBLE,
                global, local_equations, MPI_DOUBLE,
                0, MPI_COMM_WORLD);

    if (my_rank == 0)
        Print_local_vector(title, global, global_equations, 0);
}  /* Print_global_vector */


/*================================================================*/
void Cleanup_utilities(void) {
    if (global != (double*) NULL)
        free(global);
}  /* Cleanup_utilities */


/*================================================================*/
void Check_malloc(
         void*   array  /* IN */,
         char*   name   /* IN */) {
    int my_rank;

    if (array == (void*) NULL) {
        MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
        fprintf(stderr, "Process %d > Malloc of %s failed\n", 
                my_rank, name);
        fflush(stderr);
        MPI_Abort(MPI_COMM_WORLD, -1);
    }
}  /* Check_malloc */ 
