/* 
 * utility.h 
 */

#ifndef UTILITY_H
#define UTILITY_H

/* Maximum size for character arrays representing names -- e.g., 
 * filenames */
#define MAX_NAME 80

typedef int bool;
#define true 1
#define false 0

void Print_local_vector(
         char      title[]            /* IN */,
         double*   vect               /* IN */,
         int       num_equations      /* IN */,
         int       my_rank            /* IN */);

void Print_local_int_vector(
         char      title[]    /* IN */,
         int       vect[]     /* IN */,
         int       order      /* IN */,
         int       my_rank    /* IN */);

void Print_global_vector(
         char      title[]            /* IN */,
         double*   vect               /* IN */,
         int       local_equations    /* IN */,
         int       global_equations   /* IN */,
         int       my_rank            /* IN */);

void Cleanup_utilities(void);

void Check_malloc(
         void*   array  /* IN */,
         char*   name   /* IN */);
#endif
