/* merge.c
 *
 * Merges contents of a collection of files.  
 *
 * Each file should consist of a sequence of lines, and each line 
 * should consist of a sequence of numbers.  All the files should 
 * have the same number of lines; all the lines should have the
 * should have the same number of values, and all the files should
 * have the same number of values on each line.
 *
 * The filenames are assumed to have the form root.n, where root 
 * is a common prefix shared by all the the filenames, and n is an 
 * int.  If there are filecount files, the values of n should range 
 * from 0 to filecount - 1.  
 *
 * Each line of the merged file will consist of the values on he
 * the corresponding lines of the input files.  The values will
 * be ordered according to the suffixes:  values from root.0
 * first, root.1 second, etc.  The name of the merged file will
 * be the root of the input filenames.
 *
 * Compile with cc -o merge merge.c
 *
 * Usage:  merge <root> <filecount> <linecount> <values_per_input_line>
 *
 * Note:  Currently assumes values are ints.
 */
#include <stdio.h>
#include <stdlib.h>

#define MAX_NAME 100

void Usage(char* executable);
void File_open_error(char* filename, char* mode);

int main(int argc, char* argv[]) {
    FILE** fps;
    FILE* outfile;
    int filecount;
    int linecount;
    int values_per_line;
    char filename[MAX_NAME];
    int line, file, i;
    int val;

    if (argc != 5)  Usage(argv[0]);

    filecount = atoi(argv[2]);
    linecount = atoi(argv[3]);
    values_per_line = atoi(argv[4]);

    fps = (FILE**) malloc(filecount*sizeof(FILE*));
    if (fps == (FILE**) NULL) {
        fprintf(stderr, "malloc of fps failed\n");
        exit(-2);
    }

    for (file = 0; file < filecount; file++) {
        sprintf(filename, "%s.%d", argv[1], file);
        fps[file] = fopen(filename, "r");
        if (fps[file] == (FILE*) NULL)
            File_open_error(filename, "reading");
    }
    outfile = fopen(argv[1], "w");
    if (outfile == (FILE*) NULL)
        File_open_error(argv[1], "writing");

    for (line = 0; line < linecount; line++) {
        for (file = 0; file < filecount; file++) 
            for (i = 0; i < values_per_line; i++) {
                fscanf(fps[file], "%d", &val);
                fprintf(outfile, "%d ", val);
            }
        fprintf(outfile, "\n");
    }

    fclose(outfile);
    for (file = 0; file < filecount; file++)
        fclose(fps[file]);

    return 0;
}  /* main */


void Usage(char* executable) {
    fprintf(stderr, "usage:  %s <root> <filecount> ", executable);
    fprintf(stderr, "<linecount> <values_per_input_line>\n");
    exit(-1);
}  /* Usage */


void File_open_error(char* filename, char* mode) {
    fprintf(stderr, "Can't open %s for %s\n", filename, mode);
    exit(-3);
}  /* File_open_error */
