/* split_defs.h */ 

#define MAX    80
#define EXT     9
#define SUBMAX 70 

#define NUMARGS  6 
#define MAXARGC  8 

#define IF_IND 1   /* input file name index                */ 
#define OF_IND 2   /* output file name index               */ 
#define FF_IND 3   /* output file format type index        */ 
#define NP_IND 4   /* number of pieces index               */ 
#define NN_IND 5   /* number of neuron index               */ 
#define VN_IND 6   /* number of variables per neuron index */ 
#define NL_IND 7   /* number of line index                 */ 

#define EOS      '\0'   /* end of string     */
#define LPARENTH '('    /* left parenthesis  */ 
#define RPARENTH ')'    /* right parenthesis */ 

#define BY       "by" 
#define MULT     "*" 
#define TIMES    "x" 

#define SPLITFILE "splitter.rc"   /* default resource filename  */
#define READ      "r"             /* file operation mode        */
#define WRITE     "w"             /* file operation mode        */
#define READOPT   "-r"            /* com line read-file option  */
#define USAGE     "-u"            /* com line show usage option */

/* output file format type */ 
#define TEXT   1 
#define BINARY 2

#define MAXBUF 5000   /* can be as large as 6000 */  

struct parameters 
{ 
   char ifname[ MAX ];   /* input file name       */ 
   char ofname[ MAX ];   /* output file name root */ 
   int ftype;            /* file format type      */ 
   int num_pieces;       /* number of pieces              */ 
   int num_lines;        /* number of lines               */ 
   long vars_per_piece;  /* number of variables per piece */ 
}; 

