/* split_op.c */ 

#include <stdio.h> 
#include <stdlib.h> 
#include <string.h>
#include "split_defs.h" 
#include "split_util.h" 
#include "split_op.h" 

/*-------------------------------------------------------------------*/ 
void GetOutfileName( char* fname, int n, int ftype ) 
{ 
   char ext[ EXT ]; 
   int i; 

   for( i = 0; fname[ i ] != '.' && fname[ i ] != EOS; i++ ){} 
   if( fname[ i ] == '.' ) 
      fname[ i + 1 ] = EOS; 
   else 
   { 
      fname[ i ] = '.'; 
      fname[ i + 1 ] = EOS; 
   } 
   itos( (long)n, ext ); 
   strcat( fname, ext ); 
   if( ftype == BINARY ) 
      strcat( fname, "b" ); 
}

/*-------------------------------------------------------------------*/ 
void BinarySplit( FILE* ifp, FILE** ofp, int ln, int pc, long vp ) 
{ 
   if( vp < MAXBUF ) 
   { 
      printf( "single buffering called\n" ); 
      SingleBuffering( ifp, ofp, ln, pc, vp ); 
   } 
   else 
   { 
      printf( "multi buffering called\n" ); 
      MultiBuffering( ifp, ofp, ln, pc, vp ); 
   } 
} 

/*-------------------------------------------------------------------*/ 
void SingleBuffering( FILE* ifp, FILE** ofp, int ln, int pc, long vp ) 
{ 
   double* buf; 
   double val; 
   long bufsize; 
   int i, j, k; 

   /* allocate memory for buffer */ 
   bufsize = vp;   /*bufsize = vp + 1;*/  
   buf = (double*)malloc( bufsize*sizeof( double ) ); 

   for( i = 0; i < ln; i++ ) 
   { 
      fscanf( ifp, "%lf", &val ); 
      /*buf[ 0 ] = val;*/  
      for( j = 0; j < pc; j++ ) 
      { 
         for( k = 0; k < vp; k++ )   /*for( k = 1; k <= vp; k++ )*/  
         { 
            fscanf( ifp, "%lf", &val ); 
            buf[ k ] = val; 
         } 
         fwrite( buf, sizeof( double ), bufsize, ofp[ j ] ); 
      } 
   } 
   free( buf ); 
} 

/*-------------------------------------------------------------------*/ 
void MultiBuffering( FILE* ifp, FILE** ofp, int ln, int pc, long vp ) 
{ 
   double* buf; 
   double timestamp; 
   double val; 
   int bufsize; 
   int bfcount; 
   int leftover;  
   int h, i, j, k; 

   /* allocate memory for buffer */ 
   bufsize = MAXBUF; 
   buf = (double*)malloc( MAXBUF*sizeof( double ) );

   bfcount = (int)( vp/MAXBUF ); 
   leftover = (int)( vp%MAXBUF ); 

   printf( "vp = %ld\n", vp ); 
   printf( "bfcount = %d, leftover = %d\n", bfcount, leftover ); 

   for( h = 0; h < ln; h++ ) 
   { 
      fscanf( ifp, "%lf", &timestamp ); 
      for( i = 0; i < pc; i++ ) 
      { 
         /*fwrite( &timestamp, sizeof( double ), 1, ofp[ i ] );*/  
         for( j = 0; j < bfcount; j++ ) 
         { 
            for( k = 0; k < MAXBUF; k++ ) 
            { 
               fscanf( ifp, "%lf", &val ); 
               buf[ k ] = val; 
            } 
            fwrite( buf, sizeof( double ), MAXBUF, ofp[ i ] ); 
         } 
         if( leftover > 0 ) 
         { 
            for( k = 0; k < leftover; k++ ) 
            { 
               fscanf( ifp, "%lf", &val ); 
               buf[ k ] = val; 
            } 
            fwrite( buf, sizeof( double ), leftover, ofp[ i ] ); 
         } 
      } 
   } 

   free( buf ); 
} 

/*-------------------------------------------------------------------*/ 
void TextSplit( FILE* ifp, FILE** ofp, int ln, int pc, long vp ) 
{ 
   double time_stamp; 
   double val; 
   int i, j, k; 

   for( i = 0; i < ln; i++ ) 
   { 
      fscanf( ifp, "%lf", &time_stamp ); 
      for( j = 0; j < pc; j++ ) 
      { 
         /*fprintf( ofp[ j ], "%lf ", time_stamp );*/  
         for( k = 0; k < vp; k++ ) 
         { 
            fscanf( ifp, "%lf", &val ); 
            fprintf( ofp[ j ], "%f ", val ); 
         } 
         fprintf( ofp[ j ], "\n" ); 
      } 
   } 
} 

/*-------------------------------------------------------------------*/ 

