/* split_util.c */ 

#include <stdio.h> 
#include <stdlib.h> 
#include <ctype.h>
#include "split_defs.h" 
#include "split_util.h" 

/*-------------------------------------------------------------------*/
FILE* OpenFile( char* fname, char* mode ) 
{ 
   FILE* fp = fopen( fname, mode ); 

   if( fp == NULL ) 
   { 
      fprintf( stderr, "\nCannot open \"%s\"!\n\n", fname ); 
      exit( 1 ); 
   } 

   return fp; 
} 

/*-------------------------------------------------------------------*/ 
int isint( char* str )
{ 
   int i; 

   if( str[ 0 ] == EOS || str[ 0 ] == '0' ) 
      return 0; 

   for( i = 0; str[ i ] != EOS; i++ ) 
      if( !isdigit( str[ i ] ) ) 
         return 0; 

   return 1; 
} 

/*-------------------------------------------------------------------*/ 
char* GetString( FILE* fp ) 
{ 
   int i; 
   char c; 
   char tmp[ MAX ]; 
   char* str = NULL; 

   if( feof( fp ) ) 
      return NULL; 

   c = getc( fp ); 
   while( !feof( fp ) && isspace( c ) ) 
      c = getc( fp ); 

   if( feof( fp ) ) 
      return NULL; 

   i = 0; 
   while( !feof( fp ) && !isspace( c ) && i < SUBMAX ) 
   { 
      if( c == LPARENTH ) 
      { 
         while( !feof( fp ) && c != RPARENTH && i < SUBMAX ) 
         { 
            if( !isspace( c ) ) 
               tmp[ i++ ] = tolower( c ); 
            c = getc( fp ); 
         } 
      } 
      tmp[ i++ ] = c; 
      c = getc( fp ); 
   } 

   if( i == SUBMAX ) 
      i--; 
   tmp[ i ] = EOS; 
   str = (char*)malloc( i + 1 ); 
   strcpy( str, tmp ); 

   return str; 
} 

/*-------------------------------------------------------------------*/ 
void itos( long int n, char* str ) 
{ 
   char tmp[ EXT ]; 
   int sign = 1; 
   int i = 0; 
   int j = 0; 

   if( n < 0 ) 
   { 
      sign = -1; 
      n = (-1)*n; 
   } 

   do 
   { 
      tmp[ i++ ] = n%10 + '0'; 
      n /= 10; 
   } 
   while( n != 0 && i < ( EXT - 1 ) ); 

   if( i == ( EXT - 1 ) ) 
      i--; 

   if( sign < 0 ) 
      tmp[ i ] = '-'; 
   else 
      i--; 

   while( i >= 0 ) 
      str[ j++ ] = tmp[ i-- ]; 
   str[ j ] = EOS; 
} 

/*-------------------------------------------------------------------*/ 
void Usage() 
{ 
   printf( "\n----- USAGE -----\n" ); 
   printf( "Usage 1: splitter <infile_name> <outfile_name_root>\n" );  
   printf( "                  <outfile_format> <num_pieces>\n" ); 
   printf( "                  <values_per_line or num_neurons>\n" ); 
   printf( "                  <variables_per_neuron> <num_lines>\n" ); 
   printf( " - <outfile_format> should be either \"txt\" for text\n" ); 
   printf( "   file or \"bin\" for binary file.\n" ); 
   printf( " - <values_per_line> must be precededed by \"v\".\n" ); 
   printf( "   ex) splitter in out bin 4 v200 2 1000\n" ); 
   printf( " - <num_neurons> also must be precededed by \"n\".\n" ); 
   printf( "   ex) splitter in out txt 4 n100 2 1000\n\n" ); 
   printf( "Usage 2: splitter -r <resource_filename>\n" ); 
   printf( " - This will cause splitter to read a file named\n" ); 
   printf( "   <resource_filename>, which must provide the necessary\n" ); 
   printf( "   info as in \"usage 1\" command line.\n" ); 
   printf( " - In a reource file <num_neurons> can be described\n" );
   printf( "   by the number of rows and columns in parentheses.\n" );
   printf( "   ex) n(20x40), n(50 by 50), n(150 times 100)\n\n" );
   printf( "Usage 3: splitter\n" ); 
   printf( " - This will cause splitter either to read a file by\n" ); 
   printf( "   the default name \"splitter.rc\" or, if it is not\n" ); 
   printf( "   found, to get the info interactively from the user.\n\n" ); 
   printf( "Usage 4: splitter -u\n" ); 
   printf( " - This will cause splitter to display the usage.\n\n" ); 
} 

/*-------------------------------------------------------------------*/

