/* splitter.c:  split an ascii neurosys data file into p pieces for
 *              distributed input to neurondiz
 *
 * usage:  splitter <infile> <outfile> <outfile_format> <pieces> 
 *                  <values_per_line or num_neurons> 
 *                  <vars_per_neuron> <num_lines> 
 *         splitter -r <resource_filename> 
 *         splitter 
 *          * <outfile_format> is either "txt" for text file format 
 *          * "bin" for binary format. 
 *          * The 2nd and 3rd commands require a resource file which 
 *          * contains the same info as in the 1st command line. If 
 *          * the resource file has the default name "splitter.rc" 
 *          * the 3rd command works. 
 *          * Type "splitter -u" for more usage.  
 *
 * Note:  output files are named <outfile>.<i> for text file format 
 *        or <outfile>.<ib> for binary file format, where i ranges 
 *        from 0 to <pieces> - 1. 
 *
 * Note:  input file line format is
 *            time data1 data2 data3 . . . dataN
 *        where N = variables_per_line
 * 
 * Updated: 6/6/99 
 *
 */

#include <stdio.h> 
#include <stdlib.h> 

#include "split_defs.h" 
#include "split_util.h" 
#include "interpreter.h" 
#include "split_op.h" 

int main( int argc, char* argv[] ) { 
   FILE* infile; 
   FILE** outfiles; 
   struct parameters p; 
   int i; 

   /* get and check user input */ 
   ReadInput( argc, argv, &p ); 

   /* open files */ 
   infile = OpenFile( p.ifname, READ ); 
   outfiles = (FILE**)malloc( (p.num_pieces)*sizeof( FILE* ) ); 
   for( i = 0; i < (p.num_pieces); i++ ) 
   { 
      GetOutfileName( (p.ofname), i, p.ftype ); 
      outfiles[ i ] = OpenFile( (p.ofname), WRITE ); 
   } 

   /* split infile into specified number of outfiles */ 
   if( p.ftype == BINARY ) 
   { 
      BinarySplit( infile, 
                   outfiles, 
                   p.num_lines, 
                   p.num_pieces, 
                   p.vars_per_piece ); 
   } 
   else   /* p.ftype == TEXT */ 
   { 
      TextSplit( infile, 
                 outfiles, 
                 p.num_lines, 
                 p.num_pieces, 
                 p.vars_per_piece ); 
   } 

   /* close files */ 
   fclose( infile ); 
   for( i = 0; i < (p.num_pieces); i++ ) 
      fclose( outfiles[ i ] ); 
   free( outfiles ); 

   return 0;
}   /* main */

/*-------------------------------------------------------------------*/

