/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld;

import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.io.IIOPin;
import com.sun.spot.sensorboard.io.IInputPin;
import com.sun.spot.sensorboard.io.IInputPinListener;
import com.sun.spot.sensorboard.io.IOutputPin;
import com.sun.spot.sensorboard.io.IScalarInput;
import com.sun.spot.sensorboard.peripheral.ILightSensor;
import com.sun.spot.sensorboard.peripheral.ILightSensorThresholdListener;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITemperatureInput;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.sensorboard.peripheral.LEDColor;
import com.sun.spot.sensorboard.peripheral.LIS3L02AQAccelerometer;
import com.sun.spot.util.Utils;
import java.io.IOException;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class SensorChecker
extends MIDlet
implements ILightSensorThresholdListener,
ISwitchListener,
IInputPinListener {
    private EDemoBoard demo = EDemoBoard.getInstance();
    private ILightSensor light = this.demo.getLightSensor();
    private ITemperatureInput temp = this.demo.getADCTemperature();
    private IScalarInput[] scalars = this.demo.getScalarInputs();
    private ISwitch[] sw = this.demo.getSwitches();
    private ITriColorLED[] leds = this.demo.getLEDs();
    private IOutputPin[] outs = this.demo.getOutputPins();
    private IIOPin[] ins = this.demo.getIOPins();
    private LIS3L02AQAccelerometer accel = (LIS3L02AQAccelerometer)this.demo.getAccelerometer();
    private LEDColor[] colors = new LEDColor[]{LEDColor.WHITE, LEDColor.RED, LEDColor.GREEN, LEDColor.BLUE};
    private int mode = 0;

    protected void startApp() throws MIDletStateChangeException {
        this.sw[0].addISwitchListener((ISwitchListener)this);
        this.light.addILightSensorThresholdListener((ILightSensorThresholdListener)this);
        this.light.setThresholds(10, 740);
        this.light.enableThresholdEvents(true);
        this.outs[this.mode].setHigh();
        this.ins[0].setAsOutput(true);
        this.ins[1].addIInputPinListener((IInputPinListener)this);
        this.accel.setScale(1);
        while (true) {
            try {
                while (true) {
                    int bars = 0;
                    switch (this.mode) {
                        case 0: {
                            bars = this.light.getValue() / 84;
                            break;
                        }
                        case 1: {
                            bars = (int)(this.temp.getFahrenheit() + 40.0) / 20;
                            break;
                        }
                        case 2: {
                            bars = this.scalars[0].getValue() / 114;
                            break;
                        }
                        case 3: {
                            double accZ = this.accel.getAccelZ();
                            bars = (int)((accZ + 6.0) / 1.333);
                        }
                    }
                    for (int i = 0; i < 8; ++i) {
                        this.leds[i].setColor(this.colors[this.mode]);
                        this.leds[i].setOn(i < bars);
                    }
                    Utils.sleep((long)200L);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    public void thresholdExceeded(ILightSensor light, int val) {
        System.out.println("Light threshold exceeded: " + val);
        Utils.sleep((long)2000L);
        light.enableThresholdEvents(true);
    }

    public void thresholdChanged(ILightSensor light, int low, int high) {
    }

    public void switchReleased(ISwitch sw) {
        this.outs[this.mode].setHigh(false);
        if (++this.mode > 3) {
            this.mode = 0;
        }
        this.outs[this.mode].setHigh(true);
    }

    public void switchPressed(ISwitch sw) {
    }

    public void pinSetLow(IInputPin pin) {
        this.ins[0].setLow();
    }

    public void pinSetHigh(IInputPin pin) {
        this.ins[0].setHigh();
    }
}

