/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld;

import com.sun.spot.io.j2me.radiogram.Radiogram;
import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.sensorboard.peripheral.LEDColor;
import com.sun.spot.util.IEEEAddress;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class UnicastCount
extends MIDlet
implements ISwitchListener {
    private static final int CHANGE_COLOR = 1;
    private static final int CHANGE_COUNT = 2;
    private ITriColorLED[] leds = EDemoBoard.getInstance().getLEDs();
    private ISwitch[] switches = EDemoBoard.getInstance().getSwitches();
    private int count = -1;
    private int color = 0;
    private LEDColor[] colors = new LEDColor[]{LEDColor.RED, LEDColor.GREEN, LEDColor.BLUE};
    private RadiogramConnection conn = null;
    private Radiogram xdg;

    private void showCount(int count, int color) {
        int i = 7;
        int bit = 1;
        while (i >= 0) {
            if ((count & bit) != 0) {
                this.leds[i].setColor(this.colors[color]);
                this.leds[i].setOn();
            } else {
                this.leds[i].setOff();
            }
            --i;
            bit <<= 1;
        }
    }

    private void showColor(int color) {
        for (int i = 0; i < 8; ++i) {
            this.leds[i].setColor(this.colors[color]);
            this.leds[i].setOn();
        }
    }

    protected void startApp() throws MIDletStateChangeException {
        System.out.println("Broadcast Counter MIDlet");
        this.showColor(this.color);
        this.switches[0].addISwitchListener((ISwitchListener)this);
        this.switches[1].addISwitchListener((ISwitchListener)this);
        try {
            long address = Spot.getInstance().getRadioPolicyManager().getIEEEAddress();
            address = (address & 1L) == 0L ? --address : ++address;
            this.conn = (RadiogramConnection)Connector.open((String)("radiogram://" + IEEEAddress.toDottedHex((long)address) + ":123"));
            this.xdg = (Radiogram)this.conn.newDatagram(20);
            Radiogram rdg = (Radiogram)this.conn.newDatagram(20);
            while (true) {
                try {
                    while (true) {
                        this.conn.receive((Datagram)rdg);
                        int cmd = rdg.readInt();
                        int newCount = rdg.readInt();
                        int newColor = rdg.readInt();
                        if (cmd == 1) {
                            System.out.println("Received packet from " + rdg.getAddress());
                            this.showColor(newColor);
                            continue;
                        }
                        this.showCount(newCount, newColor);
                    }
                }
                catch (IOException ex) {
                    System.out.println("Error receiving packet: " + ex);
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            System.out.println("Error opening connections: " + ex);
            ex.printStackTrace();
            return;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    public void switchReleased(ISwitch sw) {
        int cmd;
        if (sw == this.switches[0]) {
            cmd = 1;
            if (++this.color >= this.colors.length) {
                this.color = 0;
            }
            this.count = -1;
        } else {
            cmd = 2;
            ++this.count;
        }
        try {
            this.xdg.reset();
            this.xdg.writeInt(cmd);
            this.xdg.writeInt(this.count);
            this.xdg.writeInt(this.color);
            this.conn.send((Datagram)this.xdg);
        }
        catch (IOException ex) {
            System.out.println("Error sending packet: " + ex);
            ex.printStackTrace();
        }
    }

    public void switchPressed(ISwitch sw) {
    }
}

