/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.test;

import com.sun.spot.peripheral.IPowerController;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.IAccelerometer3D;
import com.sun.spot.sensorboard.peripheral.ILightSensor;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ITemperatureInput;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.sensorboard.peripheral.LEDColor;
import com.sun.spot.util.Utils;
import java.io.IOException;
import java.util.Date;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class SpotCheck
extends MIDlet {
    private static final LEDColor WHITE = new LEDColor(255, 255, 255);
    private static final LEDColor GREY = new LEDColor(127, 127, 127);
    private static final LEDColor ORANGE = new LEDColor(255, 120, 0);
    private static final LEDColor DIMRED = new LEDColor(32, 0, 0);
    private ITriColorLED[] leds;
    private ISwitch sw1;
    private ISwitch sw2;
    private IPowerController avr;
    private EDemoBoard eDemo;
    private ILightSensor lightSensor;
    private IAccelerometer3D accelerometer;
    private ITemperatureInput thermometer;
    private int State1 = 0;
    private int State2 = 0;
    private int acc;
    boolean SW2Changed = true;
    private boolean connected;

    private void run() throws IOException {
        boolean has_eDemo;
        this.avr = Spot.getInstance().getPowerController();
        System.out.println("Power Controller = " + this.avr.getRevision());
        boolean bl = has_eDemo = !Spot.getInstance().getExternalBoardMap().isEmpty();
        if (has_eDemo) {
            this.eDemo = EDemoBoard.getInstance();
            this.lightSensor = this.eDemo.getLightSensor();
            this.accelerometer = this.eDemo.getAccelerometer();
            this.thermometer = this.eDemo.getADCTemperature();
            this.sw1 = this.eDemo.getSwitches()[0];
            this.sw2 = this.eDemo.getSwitches()[1];
            this.startSW1WatchThread();
            this.startSW2WatchThread();
            int[] firmwareVersion = this.eDemo.getFirmwareVersion();
            System.out.println("eDemo board revision: " + firmwareVersion[0] + "." + firmwareVersion[1]);
            this.leds = this.eDemo.getLEDs();
        } else {
            System.out.println("No eDEMO board found");
        }
        System.out.println("IEEE_ADDR = " + System.getProperty("IEEE_ADDRESS"));
        int status = this.avr.getStatus();
        System.out.println("Status was 0x" + Integer.toHexString(status));
        System.out.println(this.statusAsString(status));
        int powerFaults = this.avr.getPowerStatus();
        System.out.println("Power Fault=0x" + Integer.toHexString(powerFaults));
        System.out.println(this.faultAsString(powerFaults));
        boolean again = true;
        while (again) {
            int lightLevel = 0;
            int vcc = this.avr.getVcc();
            int vcore = this.avr.getVcore();
            int vbatt = this.avr.getVbatt();
            int vext = this.avr.getVext();
            int vusb = this.avr.getVusb();
            this.connected = vusb > 3000;
            int icharge = this.avr.getIcharge();
            int idischarge = this.avr.getIdischarge();
            if (this.connected) {
                System.out.println("Time = " + new Date(this.avr.getTime()));
            }
            if (has_eDemo) {
                int i;
                if (this.SW2Changed) {
                    for (i = 0; i < 8; ++i) {
                        this.leds[i].setOff();
                    }
                    this.leds[this.State2].setColor(WHITE);
                    this.leds[this.State2].setOn();
                    Utils.sleep((long)500L);
                    this.leds[this.State2].setOff();
                    this.SW2Changed = false;
                }
                switch (this.State2) {
                    case 0: {
                        switch (this.State1) {
                            case 0: {
                                if (icharge > idischarge) {
                                    this.ledBarGraph(icharge, 500, LEDColor.GREEN);
                                } else {
                                    this.ledBarGraph(idischarge, 500, LEDColor.RED);
                                }
                                if (!this.connected) break;
                                System.out.println(this.levelsAsString(icharge, 0, 550, "ma", "Charge Current"));
                                System.out.println(this.levelsAsString(idischarge, 0, 500, "ma", "Discharge Current"));
                                break;
                            }
                            case 1: {
                                if (vext > vusb) {
                                    this.ledBarGraph(vext, 6000, LEDColor.CYAN);
                                    System.out.println(this.levelsAsString(vext, 4500, 5500, "mV", "Vexternal"));
                                    break;
                                }
                                this.ledBarGraph(vusb, 6000, LEDColor.CYAN);
                                System.out.println(this.levelsAsString(vusb, 4500, 5500, "mV", "Vusb"));
                                break;
                            }
                            case 2: {
                                this.ledBarGraph(vbatt, 6000, LEDColor.BLUE);
                                if (!this.connected) break;
                                System.out.println(this.levelsAsString(vbatt, 2945, 4935, "mV", "Vbattery"));
                                break;
                            }
                            case 3: {
                                this.ledBarGraph(vcc, 6000, LEDColor.YELLOW);
                                if (!this.connected) break;
                                System.out.println(this.levelsAsString(vcc, 2850, 3150, "mV", "Vcc"));
                                break;
                            }
                            case 4: {
                                this.ledBarGraph(vcore, 6000, ORANGE);
                                if (!this.connected) break;
                                System.out.println(this.levelsAsString(vcore, 1710, 1890, "mV", "Vcore"));
                                break;
                            }
                            case 5: {
                                powerFaults = this.avr.getPowerStatus();
                                for (i = 0; i < 8; ++i) {
                                    if ((powerFaults >> i & 1) == 1) {
                                        this.leds[i].setColor(LEDColor.RED);
                                    } else {
                                        this.leds[i].setColor(LEDColor.GREEN);
                                    }
                                    this.leds[i].setOn();
                                }
                                if (!this.connected) break;
                                System.out.println("Power Fault=0x" + Integer.toHexString(powerFaults) + " " + this.faultAsString(powerFaults));
                                break;
                            }
                            case 6: {
                                this.State1 = 0;
                            }
                        }
                        Utils.sleep((long)100L);
                        break;
                    }
                    case 1: {
                        lightLevel = this.lightSensor.getValue();
                        this.ledBarGraph(lightLevel, 740, GREY);
                        if (this.connected) {
                            System.out.println("Light level = " + lightLevel);
                        }
                        Utils.sleep((long)100L);
                        break;
                    }
                    case 2: {
                        double temperature = this.thermometer.getFahrenheit();
                        this.ledBarGraph((int)temperature - 50, 70, DIMRED);
                        if (this.connected) {
                            System.out.println("Temperature: " + temperature + " deg. F");
                        }
                        Utils.sleep((long)100L);
                        break;
                    }
                    case 3: {
                        try {
                            switch (this.State1) {
                                case 0: {
                                    this.acc = (int)(this.accelerometer.getAccelX() * 10.0);
                                    this.ledBarGraph(this.acc + 20, 40, LEDColor.RED);
                                    if (!this.connected) break;
                                    System.out.println("Accelerometer X axis = " + this.acc);
                                    break;
                                }
                                case 1: {
                                    this.acc = (int)(this.accelerometer.getAccelY() * 10.0);
                                    this.ledBarGraph(this.acc + 20, 40, LEDColor.GREEN);
                                    if (!this.connected) break;
                                    System.out.println("Accelerometer Y axis = " + this.acc);
                                    break;
                                }
                                case 2: {
                                    this.acc = (int)(this.accelerometer.getAccelZ() * 10.0);
                                    this.ledBarGraph(this.acc + 20, 40, LEDColor.BLUE);
                                    if (!this.connected) break;
                                    System.out.println("Accelerometer Z axis = " + this.acc);
                                    break;
                                }
                                case 3: {
                                    this.State1 = 0;
                                }
                            }
                            Utils.sleep((long)50L);
                        }
                        catch (IOException e) {}
                        break;
                    }
                    case 4: {
                        for (int j = 0; j < 1024; ++j) {
                            int k = j > 512 ? 1024 - j : j;
                            switch (this.State1) {
                                case 0: {
                                    this.ledBarGraph(k, 512, LEDColor.RED);
                                    break;
                                }
                                case 1: {
                                    this.ledBarGraph(k, 512, LEDColor.GREEN);
                                    break;
                                }
                                case 2: {
                                    this.ledBarGraph(k, 512, LEDColor.BLUE);
                                    break;
                                }
                                case 3: {
                                    this.ledBarGraph(k, 512, WHITE);
                                    break;
                                }
                                case 4: {
                                    this.State1 = 0;
                                }
                            }
                            if (k != 512) continue;
                            for (int l = 0; l < 100; ++l) {
                                Utils.sleep((long)10L);
                            }
                        }
                        if (!this.connected) break;
                        System.out.println("LED Test");
                    }
                }
                continue;
            }
            int startupTime = this.avr.getStartupTime();
            System.out.println(this.levelsAsString(vcc, 2850, 3150, "mV", "Vcc"));
            System.out.println(this.levelsAsString(vcore, 1710, 1890, "mV", "Vcore"));
            System.out.println(this.levelsAsString(vbatt, 2945, 4935, "mV", "Vbattery"));
            if (vext < 3000) {
                System.out.println("No external voltage (" + vext + "mV)");
            } else {
                System.out.println(this.levelsAsString(vext, 4500, 5500, "mV", "Vexternal"));
            }
            if (vusb < 3000) {
                System.out.println("No USB voltage (" + vusb + "mV)");
            } else {
                System.out.println(this.levelsAsString(vusb, 4500, 5500, "mV", "Vusb"));
            }
            System.out.println(this.levelsAsString(icharge, 0, 550, "ma", "Charge Current"));
            System.out.println(this.levelsAsString(idischarge, 0, 500, "ma", "Discharge Current"));
            System.out.println("Power Start Time = " + startupTime + "us");
            powerFaults = this.avr.getPowerStatus();
            System.out.println("Power Fault=0x" + Integer.toHexString(powerFaults));
            System.out.println(this.faultAsString(powerFaults));
            Utils.sleep((long)2000L);
        }
    }

    private void startSW1WatchThread() {
        Runnable r = new Runnable(){

            public void run() {
                while (true) {
                    SpotCheck.this.sw1.waitForChange();
                    if (SpotCheck.this.sw1.isClosed()) {
                        SpotCheck.this.sw1Closed();
                        continue;
                    }
                    SpotCheck.this.sw1Opened();
                }
            }
        };
        new Thread(r).start();
    }

    private void startSW2WatchThread() {
        Runnable r = new Runnable(){

            public void run() {
                while (true) {
                    SpotCheck.this.sw2.waitForChange();
                    if (SpotCheck.this.sw2.isClosed()) {
                        SpotCheck.this.sw2Closed();
                        continue;
                    }
                    SpotCheck.this.sw2Opened();
                }
            }
        };
        new Thread(r).start();
    }

    private void sw1Closed() {
        ++this.State1;
    }

    private synchronized void sw2Closed() {
        ++this.State2;
        this.State1 = 0;
        this.SW2Changed = true;
        if (this.State2 > 4) {
            this.State2 = 0;
        }
    }

    private void sw1Opened() {
    }

    private void sw2Opened() {
    }

    private String faultAsString(int fault) {
        String str = "";
        if ((fault & 1) == 1) {
            str = str + ", Battery out of range";
        }
        if ((fault & 2) == 2) {
            str = str + ", USB Voltage out of range";
        }
        if ((fault & 4) == 4) {
            str = str + ", External Voltage out of range";
        }
        if ((fault & 8) == 8) {
            str = str + ", Vcc out of range";
        }
        if ((fault & 0x10) == 16) {
            str = str + ", Vcore out of range";
        }
        if ((fault & 0x20) == 32) {
            str = str + ", Power up took to long";
        }
        if ((fault & 0x40) == 64) {
            str = str + ", Current Overloaded";
        }
        if ((fault & 0x80) == 128) {
            str = str + ", RTC failed to start";
        }
        if (str == "") {
            str = "No Power Fault";
        }
        return str;
    }

    private String statusAsString(int status) {
        String str = "";
        if ((status & 1) != 0) {
            str = str + ", Cold Boot";
        }
        if ((status & 2) != 0) {
            str = str + ", Button Event";
        }
        if ((status & 4) != 0) {
            str = str + ", Alarm Event";
        }
        if ((status & 8) != 0) {
            str = str + ", Sensor Event";
        }
        if ((status & 0x10) != 0) {
            str = str + ", New Battery Event";
        }
        if ((status & 0x20) != 0) {
            str = str + ", Sleep Event";
        }
        if ((status & 0x80) != 0) {
            str = str + ", External Power Event";
        }
        return str;
    }

    private String levelsAsString(int value, int low, int high, String units, String what) {
        String str = what + ": " + value + units;
        str = value < low ? str + " below margin(" + low + units + ")" : (value > high ? str + " above margin(" + high + units + ")" : str + " ok");
        return str;
    }

    private void ledBarGraph(int num, int limit, LEDColor color) {
        if (num > limit) {
            num = limit;
        }
        if (num < 0) {
            num = 0;
        }
        int pos = num * 8 / limit;
        int frac = (num - pos * limit / 8) * 2048 / limit;
        LEDColor rc = new LEDColor(color.red() * frac / 256, color.green() * frac / 256, color.blue() * frac / 256);
        for (int i = 0; i < 8; ++i) {
            if (i < pos) {
                this.leds[i].setColor(color);
                this.leds[i].setOn();
                continue;
            }
            if (i == pos) {
                this.leds[i].setColor(rc);
                this.leds[i].setOn();
                continue;
            }
            this.leds[i].setOff();
        }
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            this.run();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }
}

