/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo;

import com.sun.spot.sensorboard.peripheral.ITriColorLED;

public class Ball {
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 4;
    private int colorKey;
    private int brightness;
    private int ledIndex;
    private int lastLEDIndex;
    private double v = 0.0;
    private double x = 3.5;
    private double oldX = 3.5;

    public Ball() {
        this.init();
    }

    public void init() {
        this.ledIndex = (int)this.x;
        this.setColorKey(4);
        this.setBrightness(100);
    }

    public String serializationString() {
        return "" + this.getX() + " " + this.getV() + " " + this.getColorKey() + " " + this.getBrightness();
    }

    public static Ball newFromSerializationStrings(String[] strs) {
        Ball b = new Ball();
        b.setX(Double.parseDouble(strs[1]));
        b.setV(Double.parseDouble(strs[2]));
        b.setColorKey(Integer.parseInt(strs[3]));
        b.setBrightness(Integer.parseInt(strs[4]));
        return b;
    }

    public void display(ITriColorLED[] leds) {
        int newB;
        int newG;
        int newR;
        ITriColorLED led2;
        ITriColorLED led1;
        this.lastLEDIndex = this.ledIndex;
        double whole = Math.floor(this.x);
        double rem = this.x - whole;
        this.ledIndex = Math.min(7, (int)whole);
        if (this.ledIndex != this.lastLEDIndex) {
            led1 = leds[this.lastLEDIndex];
            led2 = leds[Math.min(7, this.lastLEDIndex + 1)];
            if ((this.getColorKey() & 1) != 0) {
                led1.setRGB(0, led1.getGreen(), led1.getBlue());
                led2.setRGB(0, led2.getGreen(), led2.getBlue());
            }
            if ((this.getColorKey() & 2) != 0) {
                led1.setRGB(led1.getRed(), 0, led1.getBlue());
                led2.setRGB(led2.getRed(), 0, led2.getBlue());
            }
            if ((this.getColorKey() & 4) != 0) {
                led1.setRGB(led1.getRed(), led1.getGreen(), 0);
                led2.setRGB(led2.getRed(), led2.getGreen(), 0);
            }
        }
        double lbfL = Ball.linearBrightnessForLED(1.0 - rem);
        led1 = leds[this.ledIndex];
        if ((this.getColorKey() & 1) != 0 && (newR = (int)((double)this.getBrightness() * lbfL)) != led1.getRed()) {
            led1.setRGB(newR, led1.getGreen(), led1.getBlue());
        }
        if ((this.getColorKey() & 2) != 0 && (newG = (int)((double)this.getBrightness() * lbfL)) != led1.getGreen()) {
            led1.setRGB(led1.getRed(), newG, led1.getBlue());
        }
        if ((this.getColorKey() & 4) != 0 && (newB = (int)((double)this.getBrightness() * lbfL)) != led1.getBlue()) {
            led1.setRGB(led1.getRed(), led1.getGreen(), newB);
        }
        if (this.ledIndex < 7) {
            led2 = leds[this.ledIndex + 1];
            lbfL = Ball.linearBrightnessForLED(rem);
            if ((this.getColorKey() & 1) != 0 && (newR = (int)((double)this.getBrightness() * lbfL)) != led2.getRed()) {
                led2.setRGB(newR, led2.getGreen(), led2.getBlue());
            }
            if ((this.getColorKey() & 2) != 0 && (newG = (int)((double)this.getBrightness() * lbfL)) != led2.getGreen()) {
                led2.setRGB(led2.getRed(), newG, led2.getBlue());
            }
            if ((this.getColorKey() & 4) != 0 && (newB = (int)((double)this.getBrightness() * lbfL)) != led2.getBlue()) {
                led2.setRGB(led2.getRed(), led2.getGreen(), newB);
            }
        }
    }

    public static double linearBrightnessForLED(double x) {
        return x * Math.sqrt(x);
    }

    public void eraseFromDisplay(ITriColorLED[] leds) {
        ITriColorLED led1 = leds[this.ledIndex];
        ITriColorLED led2 = leds[Math.min(7, this.ledIndex + 1)];
        if ((this.getColorKey() & 1) != 0) {
            led1.setRGB(0, led1.getGreen(), led1.getBlue());
            led2.setRGB(0, led2.getGreen(), led2.getBlue());
        }
        if ((this.getColorKey() & 2) != 0) {
            led1.setRGB(led1.getRed(), 0, led1.getBlue());
            led2.setRGB(led2.getRed(), 0, led2.getBlue());
        }
        if ((this.getColorKey() & 4) != 0) {
            led1.setRGB(led1.getRed(), led1.getGreen(), 0);
            led2.setRGB(led2.getRed(), led2.getGreen(), 0);
        }
    }

    public double getV() {
        return this.v;
    }

    public void setV(double v) {
        this.v = v;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x2) {
        this.oldX = this.x;
        this.x = x2;
    }

    public void mixInColorKey(int ck) {
        this.setColorKey(this.getColorKey() | ck);
    }

    public int getColorKey() {
        return this.colorKey;
    }

    public void setColorKey(int colorKey) {
        this.colorKey = colorKey;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public double getOldX() {
        return this.oldX;
    }
}

