/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo;

import com.sun.spot.sensorboard.peripheral.IAccelerometer3D;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import java.io.IOException;
import java.util.Vector;
import org.sunspotworld.demo.Ball;
import org.sunspotworld.demo.SPOTBounce;

public class BallAnimator {
    private ITriColorLED[] leds;
    private SPOTBounce client;
    Vector balls = new Vector();
    private IAccelerometer3D accelerometer;
    private double dt;
    double friction;
    double conv = 0.001764;
    boolean debug = false;

    public BallAnimator() {
        this.init();
    }

    public void init() {
        this.setDt(10.0);
        this.friction = 5.0E-4;
    }

    public int getNumBalls() {
        return this.balls.size();
    }

    public synchronized void addBall(Ball b) {
        this.balls.addElement(b);
        this.sortAndReport();
    }

    public synchronized void colorFirstBall(int key) {
        if (this.balls.size() == 0) {
            return;
        }
        Ball b = (Ball)this.balls.elementAt(0);
        b.eraseFromDisplay(this.leds);
        b.setColorKey(key);
        b.display(this.leds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doKinematics() {
        double aX = 0.0;
        try {
            aX = this.accelerometer.getAccelX() * this.conv;
        }
        catch (IOException ex) {
            aX = 0.0;
            ex.printStackTrace();
        }
        for (int i = 0; i < this.balls.size(); ++i) {
            Ball ball = (Ball)this.balls.elementAt(i);
            double v = ball.getV();
            double x = ball.getX();
            if ((x = x + (v += (aX -= this.friction * v) * this.dt) * this.dt + 0.5 * aX * this.dt * this.dt) > 6.99 && Math.abs(v) < 0.019) {
                x = 7.0;
                v = 0.0;
            }
            if (x < 0.01 && Math.abs(v) < 0.019) {
                x = 0.0;
                v = 0.0;
            }
            ball.setX(x);
            ball.setV(v);
            SPOTBounce sPOTBounce = this.client;
            synchronized (sPOTBounce) {
                if (x < 0.0) {
                    if (this.client.isLeftEndOpen()) {
                        ball.eraseFromDisplay(this.leds);
                        ball.setV(Math.abs(v));
                        ball.setX(Math.min(7.0, -x));
                        this.client.ballOffEnd(ball, true);
                        this.balls.removeElement(ball);
                    } else {
                        ball.setV(-v);
                        ball.setX(Math.min(7.0, -x));
                    }
                }
            }
            sPOTBounce = this.client;
            synchronized (sPOTBounce) {
                if (x > 7.0) {
                    if (this.client.isRightEndOpen()) {
                        ball.eraseFromDisplay(this.leds);
                        ball.setV(Math.abs(v));
                        ball.setX(Math.min(7.0, x - 7.0));
                        this.client.ballOffEnd(ball, false);
                        this.balls.removeElement(ball);
                    } else {
                        ball.setV(-v);
                        double excess = x - 7.0;
                        ball.setX(Math.max(0.0, 7.0 - excess));
                    }
                }
                continue;
            }
        }
        Vector bls = this.sortAndReport();
        if (bls.size() != 0) {
            this.mergeBalls(bls);
        }
    }

    public void mergeBalls(Vector bs) {
        Ball newBall = new Ball();
        double x = 0.0;
        double v = 0.0;
        int ck = 0;
        for (int i = 0; i < bs.size(); ++i) {
            Ball b = (Ball)bs.elementAt(i);
            x += b.getX();
            v += b.getV();
            ck |= b.getColorKey();
            this.balls.removeElement(bs.elementAt(i));
            b.eraseFromDisplay(this.leds);
        }
        this.flash(x /= (double)bs.size());
        newBall.setX(x);
        newBall.setV(v /= (double)bs.size());
        newBall.setColorKey(ck);
        this.balls.addElement(newBall);
        this.sortAndReport();
    }

    public Vector sortAndReport() {
        Vector<Ball> r = new Vector<Ball>();
        if (this.balls.size() <= 1) {
            return r;
        }
        for (int i = 1; i < this.balls.size(); ++i) {
            int j;
            Ball bi = (Ball)this.balls.elementAt(i);
            double x = bi.getX();
            Ball bj = (Ball)this.balls.elementAt(j);
            for (j = i - 1; j >= 0 && x <= bj.getX(); --j) {
                if (Math.abs(bj.getV() - bi.getV()) < 0.03) {
                    r.addElement(bi);
                    r.addElement(bj);
                }
                this.balls.removeElement(bi);
                this.balls.insertElementAt(bi, j);
            }
        }
        return r;
    }

    public void display() {
        for (int i = 0; i < this.balls.size(); ++i) {
            Ball ball = (Ball)this.balls.elementAt(i);
            ball.display(this.leds);
        }
    }

    public synchronized void flash(double x) {
        int i;
        int[] r = new int[this.leds.length];
        int[] g = new int[this.leds.length];
        int[] b = new int[this.leds.length];
        int ledMin = Math.min(this.leds.length, Math.max(0, (int)(x - 1.75)));
        int ledMax = Math.min(this.leds.length, Math.max(0, (int)(x + 2.75)));
        for (i = 0; i < this.leds.length; ++i) {
            r[i] = this.leds[i].getRed();
            g[i] = this.leds[i].getGreen();
            b[i] = this.leds[i].getBlue();
        }
        for (i = ledMin; i < ledMax; ++i) {
            this.leds[i].setRGB(255, 255, 255);
        }
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        for (int i2 = 0; i2 < this.leds.length; ++i2) {
            this.leds[i2].setRGB(r[i2], g[i2], b[i2]);
        }
    }

    public IAccelerometer3D getAccelerometer() {
        return this.accelerometer;
    }

    public void setAccelerometer(IAccelerometer3D accelerometer) {
        this.accelerometer = accelerometer;
    }

    public SPOTBounce getClient() {
        return this.client;
    }

    public void setClient(SPOTBounce client) {
        this.client = client;
    }

    public ITriColorLED[] getLeds() {
        return this.leds;
    }

    public void setLeds(ITriColorLED[] leds) {
        this.leds = leds;
    }

    public double getDt() {
        return this.dt;
    }

    public void setDt(double dt) {
        this.dt = dt;
    }
}

