/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo;

import com.sun.spot.peripheral.Spot;
import java.util.Vector;
import org.sunspotworld.demo.SPOTBounce;

public class BallColorSetter {
    private SPOTBounce client;
    private Vector addresses;
    private long thisAddressAsNumber;

    public BallColorSetter() {
        this.init();
    }

    public void init() {
        this.thisAddressAsNumber = Spot.getInstance().getRadioPolicyManager().getIEEEAddress();
        this.addresses = new Vector();
    }

    public void collectAddress(long address) {
        if (this.addresses.contains(new Long(address))) {
            return;
        }
        this.addresses.addElement(new Long(address));
        this.assessAndInformClient();
    }

    public void assessAndInformClient() {
        long total = 0L;
        for (int i = 0; i < this.addresses.size(); ++i) {
            long a = (Long)this.addresses.elementAt(i);
            if (a > this.thisAddressAsNumber) {
                ++total;
            }
            if (a >= this.thisAddressAsNumber) continue;
            --total;
        }
        if (this.addresses.size() > 0) {
            boolean thatsEnoughOfThat = this.addresses.size() >= 2;
            this.client.initialBallColorCue(total, thatsEnoughOfThat);
        }
    }

    public SPOTBounce getClient() {
        return this.client;
    }

    public void setClient(SPOTBounce client) {
        this.client = client;
    }
}

