/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo;

import com.sun.spot.sensorboard.io.PinDescriptor;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.sensorboard.peripheral.LEDColor;

public class MyTriColorLED
implements ITriColorLED {
    private static MyTriColorLED[] myleds = null;
    ITriColorLED realLED;
    int idx;
    int r;
    int g;
    int b;
    boolean on;

    public MyTriColorLED(int index, ITriColorLED realLED) {
        this.realLED = realLED;
        this.idx = index;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.on = false;
    }

    public static ITriColorLED[] getLEDs(ITriColorLED[] leds) {
        if (myleds != null) {
            return myleds;
        }
        myleds = new MyTriColorLED[leds.length];
        for (int i = 0; i < leds.length; ++i) {
            MyTriColorLED.myleds[i] = new MyTriColorLED(i, leds[i]);
        }
        return myleds;
    }

    public void setRGB(int redRGB, int greenRGB, int blueRGB) {
        this.r = redRGB;
        this.g = greenRGB;
        this.b = blueRGB;
        this.setOn(this.on);
    }

    public void setColor(LEDColor clr) {
        this.r = clr.red();
        this.g = clr.green();
        this.b = clr.blue();
        this.setOn(this.on);
    }

    public LEDColor getColor() {
        return new LEDColor(this.r, this.g, this.b);
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public PinDescriptor getIndex() {
        return null;
    }

    public void setOn() {
        this.setOn(true);
    }

    public void setOff() {
        this.setOn(false);
    }

    public void setOn(boolean on) {
        this.on = on;
        if (this.on) {
            this.realLED.setRGB(this.r, this.g, this.b);
            this.realLED.setOn();
        } else {
            this.realLED.setOff();
        }
    }

    public boolean isOn() {
        return this.on;
    }
}

