/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo;

import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.IDemoBoard;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.util.IEEEAddress;
import com.sun.spot.util.Utils;
import com.sun.squawk.util.StringTokenizer;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import org.sunspotworld.demo.Ball;
import org.sunspotworld.demo.BallAnimator;
import org.sunspotworld.demo.BallColorSetter;
import org.sunspotworld.demo.MyTriColorLED;
import org.sunspotworld.demo.utilities.RadioDataIOStream;

public class SPOTBounce
extends MIDlet
implements ISwitchListener {
    private static int MIN_CHANNEL = 43;
    private IDemoBoard sensorBoard;
    BallAnimator animator;
    BallColorSetter initialBallColorSetter;
    ISwitch sw1;
    ISwitch sw2;
    boolean colorIsDetermined;
    boolean receivedWhoWantsToPlay;
    boolean seekingConnectLeft;
    boolean seekingConnectRight;
    boolean listeningForAPartner;
    DatagramConnection dgBConn;
    RadioDataIOStream leftIOStream;
    RadioDataIOStream rightIOStream;
    long thisAddressAsNumber;
    private RadiogramConnection connListenPartner;

    public void initialize() {
        this.colorIsDetermined = false;
        this.seekingConnectRight = false;
        this.seekingConnectLeft = false;
        this.listeningForAPartner = false;
        ITriColorLED[] leds = MyTriColorLED.getLEDs(this.getSensorBoard().getLEDs());
        for (int i = 0; i < 8; ++i) {
            leds[i].setOn();
            leds[i].setRGB(1, 1, 1);
            leds[i].setRGB(0, 0, 0);
        }
        this.initialBallColorSetter = new BallColorSetter();
        this.initialBallColorSetter.setClient(this);
        this.animator = new BallAnimator();
        this.animator.setClient(this);
        this.animator.setLeds(leds);
        this.thisAddressAsNumber = Spot.getInstance().getRadioPolicyManager().getIEEEAddress();
        this.sw1 = this.getSensorBoard().getSwitches()[0];
        this.sw2 = this.getSensorBoard().getSwitches()[1];
        this.sw1.addISwitchListener((ISwitchListener)this);
        this.sw2.addISwitchListener((ISwitchListener)this);
        Ball ball = new Ball();
        ball.setColorKey(4);
        this.animator.addBall(ball);
        this.animator.setAccelerometer(this.getSensorBoard().getAccelerometer());
        this.startListenForAPartnerThread();
    }

    public void start() throws IOException {
        this.initialize();
        this.startLeftEndDisplay();
        this.startRightEndDisplay();
        this.startPingForInitialColorThread();
        while (true) {
            this.animator.doKinematics();
            this.animator.display();
            try {
                Thread.sleep((int)this.animator.getDt());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void initRadioStream(String addr, int port, boolean toLeft) {
        if (toLeft) {
            this.leftIOStream = RadioDataIOStream.open(addr, port);
        } else {
            this.rightIOStream = RadioDataIOStream.open(addr, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendRadioStreamMessage(String m, RadioDataIOStream strm) throws IOException {
        RadioDataIOStream radioDataIOStream = strm;
        synchronized (radioDataIOStream) {
            strm.writeUTF(m);
            strm.flush();
        }
    }

    public synchronized void sendBroadcastMessage(String m) {
        try {
            if (this.dgBConn == null) {
                this.dgBConn = (DatagramConnection)Connector.open((String)"radiogram://broadcast:37");
            }
        }
        catch (IOException ex) {
            System.out.println("Could not open radiogram broadcast connection");
            ex.printStackTrace();
            return;
        }
        try {
            Datagram dg = this.dgBConn.newDatagram(this.dgBConn.getMaximumLength());
            dg.writeUTF(m);
            this.dgBConn.send(dg);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void startPingForInitialColorThread() {
        new Thread(){

            public void run() {
                Random rand = new Random(SPOTBounce.this.thisAddressAsNumber);
                while (!SPOTBounce.this.colorIsDetermined) {
                    SPOTBounce.this.sendBroadcastMessage("PingForColor");
                    Utils.sleep((long)(1000 + rand.nextInt(1000)));
                }
                SPOTBounce.this.sendBroadcastMessage("PingForColor");
            }
        }.start();
    }

    public void initialBallColorCue(long x, boolean stopPinging) {
        System.out.println("Initial ball color cue = " + x);
        if (this.colorIsDetermined || this.animator.getNumBalls() != 1) {
            return;
        }
        if (x > 0L) {
            this.animator.colorFirstBall(4);
        } else if ((int)x == 0) {
            this.animator.colorFirstBall(1);
        } else if (x < 0L) {
            this.animator.colorFirstBall(2);
        }
        if (stopPinging) {
            this.colorIsDetermined = true;
        }
    }

    public void startInvitationThread() throws IOException {
        new Thread(){
            Random rand;
            {
                this.rand = new Random(SPOTBounce.this.thisAddressAsNumber);
            }

            public void run() {
                boolean keepRunning;
                boolean bl = keepRunning = SPOTBounce.this.seekingConnectLeft || SPOTBounce.this.seekingConnectRight;
                while (keepRunning) {
                    int[] ap = SPOTBounce.this.generate3AvailablePortNumbers();
                    SPOTBounce.this.sendBroadcastMessage("PlayCatch? " + ap[0] + " " + ap[1] + " " + ap[2]);
                    Utils.sleep((long)(1000 + this.rand.nextInt(1000)));
                    keepRunning = SPOTBounce.this.seekingConnectLeft || SPOTBounce.this.seekingConnectRight;
                }
            }
        }.start();
    }

    public void startListenForAPartnerThread() {
        new Thread(){

            public void run() {
                try {
                    SPOTBounce.this.listenForAPartner();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    private String[] separateStrings(String msg) {
        StringTokenizer stk = new StringTokenizer(msg, " ");
        String[] result = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreTokens()) {
            result[i] = stk.nextToken();
            ++i;
        }
        return result;
    }

    public void listenForAPartner() throws IOException {
        this.listeningForAPartner = true;
        int port = -1;
        if (this.connListenPartner == null) {
            this.connListenPartner = (RadiogramConnection)Connector.open((String)"radiogram://:37");
        }
        Datagram dg = this.connListenPartner.newDatagram(this.connListenPartner.getMaximumLength());
        boolean acceptingInvitation = false;
        boolean foundPartner = false;
        System.out.println("[listenForAPartner] started.");
        while (this.listeningForAPartner) {
            acceptingInvitation = false;
            foundPartner = false;
            this.connListenPartner.receive(dg);
            String message = dg.readUTF();
            String[] messageTokens = this.separateStrings(message);
            String otherAddress = dg.getAddress();
            long otherAddressAsNumber = IEEEAddress.toLong((String)otherAddress);
            if (messageTokens[0].equals("PingForColor")) {
                this.initialBallColorSetter.collectAddress(otherAddressAsNumber);
            }
            if (!this.seekingConnectLeft && !this.seekingConnectRight) continue;
            if (messageTokens[0].equals("PlayCatch?") && this.thisAddressAsNumber < otherAddressAsNumber) {
                port = this.selectPortFrom(messageTokens[1], messageTokens[2], messageTokens[3]);
                this.replyWithDatagram("Sure " + port, dg);
            } else if (messageTokens[0].equals("Sure") && this.thisAddressAsNumber > otherAddressAsNumber) {
                port = Integer.valueOf(messageTokens[1]);
                this.replyWithDatagram("Confirm", dg);
                acceptingInvitation = true;
                foundPartner = true;
            } else {
                foundPartner = messageTokens[0].equals("Confirm");
            }
            if (!foundPartner) continue;
            if (this.seekingConnectLeft) {
                this.initRadioStream(otherAddress, port, true);
                this.startRadioStreamListenerThread(this.leftIOStream);
                acceptingInvitation = false;
                this.seekingConnectLeft = false;
            }
            if (!this.seekingConnectRight) continue;
            this.initRadioStream(otherAddress, port, false);
            this.startRadioStreamListenerThread(this.rightIOStream);
            acceptingInvitation = false;
            this.seekingConnectRight = false;
        }
        System.out.println("[listenForAPartner] exiting.");
    }

    public void replyWithDatagram(String message, Datagram adressSourceDG) {
        Datagram dgreply;
        try {
            dgreply = this.connListenPartner.newDatagram(this.connListenPartner.getMaximumLength());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        dgreply.reset();
        dgreply.setAddress(adressSourceDG);
        try {
            dgreply.writeUTF(message);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            this.connListenPartner.send(dgreply);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private int selectPortFrom(String string, String string0, String string1) {
        String pn;
        Vector<String> pieces = new Vector<String>();
        pieces.addElement(string);
        pieces.addElement(string0);
        pieces.addElement(string1);
        if (this.leftIOStream != null && pieces.contains(pn = "" + this.leftIOStream.getPortNumber())) {
            pieces.removeElement(pn);
        }
        if (this.rightIOStream != null && pieces.contains(pn = "" + this.rightIOStream.getPortNumber())) {
            pieces.removeElement(pn);
        }
        int port = Integer.parseInt((String)pieces.elementAt(0));
        return port;
    }

    public int selectPortFromMessage(String message) {
        String[] messageTokens = this.separateStrings(message);
        return this.selectPortFrom(messageTokens[1], messageTokens[2], messageTokens[3]);
    }

    public void startRadioStreamListenerThread(final RadioDataIOStream strm) {
        new Thread(){

            public void run() {
                boolean listen = true;
                while (listen) {
                    String s = "";
                    try {
                        s = strm.readUTF();
                    }
                    catch (IOException e) {
                        listen = false;
                    }
                    if (s.equals("Close")) {
                        strm.close();
                        listen = false;
                        continue;
                    }
                    if (s.equals("")) continue;
                    SPOTBounce.this.messageArrived(SPOTBounce.this.separateStrings(s), strm == SPOTBounce.this.leftIOStream);
                }
            }
        }.start();
    }

    public void ballOffEnd(Ball ball, boolean toLeft) {
        this.colorIsDetermined = true;
        try {
            if (toLeft) {
                this.sendRadioStreamMessage("takeBall " + ball.serializationString(), this.leftIOStream);
            } else {
                this.sendRadioStreamMessage("takeBall " + ball.serializationString(), this.rightIOStream);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void messageArrived(String[] strs, boolean lefEnd) {
        if ("takeBall".equals(strs[0])) {
            this.colorIsDetermined = true;
            Ball b = Ball.newFromSerializationStrings(strs);
            this.takeNewBall(b, lefEnd);
        }
    }

    public void takeNewBall(Ball ball, boolean leftEnd) {
        if (!leftEnd) {
            ball.setX(7.0 - ball.getX());
            ball.setV(-ball.getV());
        }
        this.animator.addBall(ball);
    }

    public synchronized void sw1Closed() {
        if (this.isLeftEndOpen()) {
            try {
                this.sendRadioStreamMessage("Close", this.leftIOStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.leftIOStream.close();
            return;
        }
        if (this.seekingConnectRight) {
            this.seekingConnectRight = false;
            if (this.rightIOStream != null) {
                this.rightIOStream.close();
            }
        }
        if (this.seekingConnectLeft) {
            this.seekingConnectLeft = false;
            if (this.leftIOStream != null) {
                this.leftIOStream.close();
            }
            return;
        }
        this.seekingConnectLeft = true;
        try {
            this.startInvitationThread();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void sw2Closed() {
        if (this.isRightEndOpen()) {
            try {
                this.sendRadioStreamMessage("Close", this.rightIOStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.rightIOStream.close();
            return;
        }
        if (this.seekingConnectLeft) {
            this.seekingConnectLeft = false;
            if (this.leftIOStream != null) {
                this.leftIOStream.close();
            }
        }
        if (this.seekingConnectRight) {
            this.seekingConnectRight = false;
            if (this.rightIOStream != null) {
                this.rightIOStream.close();
            }
            return;
        }
        this.seekingConnectRight = true;
        try {
            this.startInvitationThread();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void switchPressed(ISwitch sw) {
        if (sw == this.sw1) {
            this.sw1Closed();
        } else {
            this.sw2Closed();
        }
    }

    public void switchReleased(ISwitch sw) {
    }

    public int[] generate3AvailablePortNumbers() {
        int[] r = new int[3];
        Vector<Integer> used = new Vector<Integer>();
        if (this.leftIOStream != null && this.leftIOStream.isOpen()) {
            used.addElement(new Integer(this.leftIOStream.getPortNumber()));
        }
        if (this.rightIOStream != null && this.rightIOStream.isOpen()) {
            used.addElement(new Integer(this.rightIOStream.getPortNumber()));
        }
        int c = MIN_CHANNEL;
        int index = 0;
        while (index < 3) {
            if (!used.contains(new Integer(c))) {
                r[index] = c;
                ++index;
            }
            ++c;
        }
        return r;
    }

    IDemoBoard getSensorBoard() {
        return this.sensorBoard;
    }

    public void setSensorBoard(IDemoBoard sensorBoard) {
        this.sensorBoard = sensorBoard;
    }

    public void setIDemoBoard(IDemoBoard sb) {
        this.sensorBoard = sb;
    }

    public boolean isLeftEndOpen() {
        if (this.leftIOStream == null) {
            return false;
        }
        return this.leftIOStream.isOpen();
    }

    public boolean isRightEndOpen() {
        if (this.rightIOStream == null) {
            return false;
        }
        return this.rightIOStream.isOpen();
    }

    public void startLeftEndDisplay() {
        final ITriColorLED led = MyTriColorLED.getLEDs(this.getSensorBoard().getLEDs())[0];
        new Thread(){

            public void run() {
                boolean wasClosed = false;
                boolean isClosed = !SPOTBounce.this.isLeftEndOpen();
                while (true) {
                    boolean bl = isClosed = !SPOTBounce.this.isLeftEndOpen();
                    if (isClosed && !SPOTBounce.this.seekingConnectLeft) {
                        if (led.getRed() < 20) {
                            led.setRGB(4, led.getGreen(), led.getBlue());
                        }
                    } else if (isClosed && SPOTBounce.this.seekingConnectLeft) {
                        int r = led.getRed();
                        if ((r -= 2) < 0) {
                            r = 20;
                        }
                        led.setRGB(r, led.getGreen(), led.getBlue());
                    } else if (!isClosed && wasClosed) {
                        led.setRGB(0, led.getGreen(), led.getBlue());
                    }
                    Utils.sleep((long)50L);
                    wasClosed = isClosed;
                }
            }
        }.start();
    }

    public void startRightEndDisplay() {
        final ITriColorLED led = MyTriColorLED.getLEDs(this.getSensorBoard().getLEDs())[7];
        new Thread(){

            public void run() {
                boolean wasClosed = false;
                boolean isClosed = !SPOTBounce.this.isRightEndOpen();
                while (true) {
                    boolean bl = isClosed = !SPOTBounce.this.isRightEndOpen();
                    if (isClosed && !SPOTBounce.this.seekingConnectRight) {
                        if (led.getRed() < 20) {
                            led.setRGB(4, led.getGreen(), led.getBlue());
                        }
                    } else if (isClosed && SPOTBounce.this.seekingConnectRight) {
                        int r = led.getRed();
                        if ((r -= 2) < 0) {
                            r = 20;
                        }
                        led.setRGB(r, led.getGreen(), led.getBlue());
                    } else if (!isClosed && wasClosed) {
                        led.setRGB(0, led.getGreen(), led.getBlue());
                    }
                    Utils.sleep((long)50L);
                    wasClosed = isClosed;
                }
            }
        }.start();
    }

    protected void startApp() throws MIDletStateChangeException {
        SPOTBounce sb = new SPOTBounce();
        sb.setSensorBoard((IDemoBoard)EDemoBoard.getInstance());
        try {
            sb.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        ITriColorLED[] leds = MyTriColorLED.getLEDs(this.getSensorBoard().getLEDs());
        for (int i = 0; i < 8; ++i) {
            leds[i].setOff();
        }
    }
}

