/*
 * Decompiled with CFR 0.152.
 */
package org.sunspotworld.demo.utilities;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class RadioDataIOStream
implements DataInput,
DataOutput {
    StreamConnection conn;
    DataInputStream dis;
    DataOutputStream dos;
    private int portNumber;
    private boolean open = false;

    RadioDataIOStream() {
    }

    public static RadioDataIOStream open(String addr, int p) {
        RadioDataIOStream s = new RadioDataIOStream();
        s.init(p, addr);
        return s;
    }

    public synchronized void init(int p, String addr) {
        String url = "radiostream://" + addr + ":" + p;
        this.portNumber = p;
        try {
            this.conn = (StreamConnection)Connector.open((String)url);
            this.dos = this.conn.openDataOutputStream();
            this.dis = this.conn.openDataInputStream();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.open = true;
    }

    public synchronized void close() {
        try {
            if (this.dos != null) {
                this.dos.close();
                this.dos = null;
            }
            if (this.dis != null) {
                this.dis.close();
                this.dis = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.open = false;
    }

    public void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
    }

    public void readFully(byte[] b, int i, int j) throws IOException {
        this.dis.readFully(b, i, j);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public String readLine() throws IOException {
        throw new Error("Depricated, unimplemented");
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b, int i, int j) throws IOException {
        this.dos.write(b, i, j);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        throw new Error("Unimplemented for J2ME compatibility.");
    }

    public void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        this.dos.writeUTF(str);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void flush() throws IOException {
        if (this.dos != null) {
            this.dos.flush();
        }
    }
}

