/*
* Copyright (c) 2006 Sun Microsystems, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to 
* deal in the Software without restriction, including without limitation the 
* rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
* sell copies of the Software, and to permit persons to whom the Software is 
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in 
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
 **/       
package org.sunspotworld.demo;

import org.sunspotworld.demo.simspot.simsensorboard.SimEDemoBoard;
import org.sunspotworld.demo.simspot.simsensorboard.io.SimAccelerometer;
import org.sunspotworld.demo.simspot.simsensorboard.io.SimAccelerometer3D;
import org.sunspotworld.demo.simspot.SimDisplayPanel; 
import java.io.IOException; 
import org.sunspotworld.demo.SPOTBounce;

/**
 * The main class for runing a simulated Ectoplasmic Boucing Ball Demo
 * Important to note: Because this class inherits from SPOTBounce, it
 * actually runs code that also runs on the Sun SPOT. It adds a main() method to open a window, 
 * and overrides initialize() to set the sensor board to be the sigleton of class SimEDemoBoard, and 
 * to turn on one simulated accelerometer. Other than that this class runs inherited code in the companion
 * project for the Sun SPOT device.
 * @author randy
 */
public class DesktopBounce extends SPOTBounce {
       
//    public  static final String DEFAULT_BASESTATION = "20";
    
    public void initialize(){   
       // System.setProperty("BASESTATION_ADDRESS", DesktopBounce.DEFAULT_BASESTATION);   
        setSensorBoard(SimEDemoBoard.getSimInstance());
        ((SimAccelerometer)((SimAccelerometer3D)(getSensorBoard().getAccelerometer())).getXAxis()).setOn(true); 
        super.initialize();
    }
    
    public static void main(String[] args) {
        SimDisplayPanel sdp = new SimDisplayPanel();
        sdp.initBaseStation();
        sdp.openInWindow();
        try {
            (new DesktopBounce()).start();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}
