/*
* Copyright (c) 2006 Sun Microsystems, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to 
* deal in the Software without restriction, including without limitation the 
* rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
* sell copies of the Software, and to permit persons to whom the Software is 
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in 
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
 **/       
package org.sunspotworld.demo.simspot.simsensorboard;

import com.sun.spot.peripheral.IFlashMemoryDevice;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.IDemoBoard;  
import com.sun.spot.sensorboard.io.IIOPin;
import com.sun.spot.sensorboard.io.IInputPin;
import com.sun.spot.sensorboard.io.IOutputPin;
import com.sun.spot.sensorboard.io.IScalarInput;
//import com.sun.spot.sensorboard.io.ITemperatureInput;
import com.sun.spot.sensorboard.peripheral.ITemperatureInput;
import com.sun.spot.sensorboard.io.PinDescriptor;
import com.sun.spot.sensorboard.peripheral.IAccelerometer3D;
import com.sun.spot.sensorboard.peripheral.ILightSensor;
import com.sun.spot.sensorboard.peripheral.IServo;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.IToneGenerator;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
//import com.sun.spot.util.Properties;
import java.util.Properties;
import org.sunspotworld.demo.simspot.SimSPOT;
import org.sunspotworld.demo.simspot.simsensorboard.io.SimAccelerometer;
import org.sunspotworld.demo.simspot.simsensorboard.io.SimAccelerometer3D;
import org.sunspotworld.demo.simspot.simsensorboard.io.SimSwitch;
import org.sunspotworld.demo.simspot.simsensorboard.led.SimTriColorLED;

/**
 *A simulated sensor board. It mainly provides accessors for simulated parts on the "board"
 * @author randy
 */
public class SimEDemoBoard implements IDemoBoard {
    
    /**
     * Creates a new instance of SimEDemoBoard
     */
    
    
    public SimEDemoBoard(){
        initSim();
    }
    
    static SimEDemoBoard soleInstance;
    
    public static SimEDemoBoard getSimInstance(){
        if(soleInstance == null)
            soleInstance = new SimEDemoBoard();
        return soleInstance;
    }
    
    private SimSPOT spot;
    Properties properties;
    SimAccelerometer3D accel3D;
    SimTriColorLED[] leds;
    SimSwitch sw1, sw2;
    SimSwitch[] switches;
    
    
    public void initSim(){
        properties = new Properties();
        accel3D = new SimAccelerometer3D();
        SimAccelerometer a = new SimAccelerometer();
        a.beXOrientation();
        accel3D.setXAxis(a);
        a = new SimAccelerometer();
        a.beYOrientation();
        accel3D.setYAxis(a);
        a = new SimAccelerometer();
        a.beZOrientation();
        accel3D.setZAxis(a);
        
        leds = new SimTriColorLED[8];
        if(spot != null){
            placeLEDsOnSPOT();
        }
        switches = new SimSwitch[2];
        SimSwitch s = new SimSwitch();
        s.setName("1");
        switches[0] = s;
        s = new SimSwitch();
        s.setName("2");
        switches[1] = s;
        if(spot != null){
            placeSwitchesOnSPOT();
        }
    }
    
    public void placeLEDsOnSPOT(){
        for(int i = 0; i < 8; i++){
            leds[i] = new SimTriColorLED();
            int x = spot.getXLEDStart() + i * 10;
            int y = spot.getYLEDStart();
            leds[i].setPosition(x , y);
            spot.add(leds[i]);
        }
    }
    
    public void placeSwitchesOnSPOT(){
        spot.setSwitches(switches);
        for (int i = 0; i < switches.length; i++) {
            SimSwitch s = switches[i];
            if(s.getName().equals("1")){
                s.setBounds(spot.getSw1Org().x, spot.getSw1Org().y, s.getWidth(), s.getHeight());
            }
            if(s.getName().equals("2")){
                s.setBounds(spot.getSw2Org().x, spot.getSw2Org().y, s.getWidth(), s.getHeight());
            }
        }
              
    }
    
    public SimSPOT getSpot() {
        return spot;
    }
    
    public void setSpot(SimSPOT spot) {
        this.spot = spot;
        placeLEDsOnSPOT();
        ((SimAccelerometer)(accel3D.getXAxis())).setMotionSource(spot);
        ((SimAccelerometer)(accel3D.getYAxis())).setMotionSource(spot);
        ((SimAccelerometer)(accel3D.getZAxis())).setMotionSource(spot);
        placeSwitchesOnSPOT();
    }
    
    public String name() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public boolean tearDown() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public void setUp() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public void setAccelerometer3DScale(int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
   
    public ISwitch[] getSwitches() {
        return switches;
    }
    
    public IAccelerometer3D getAccelerometer() {
        return accel3D;
    }
    
    public ILightSensor getLightSensor() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public ITemperatureInput getADCTemperature() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ITriColorLED[] getLEDs() {
        return leds;
    }

    public IScalarInput bindScalarInput(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int getScalarValue(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ISwitch bindSwitch(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean getSwitchState(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ITriColorLED bindLED(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setLEDValue(PinDescriptor pinDescriptor, int i, int i0, int i1) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setLEDColorIntensity(PinDescriptor pinDescriptor, int i, int i0) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IServo bindServo(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void startPulse(PinDescriptor pinDescriptor, int i, int i0) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IOutputPin bindOutputPin(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IInputPin bindInputPin(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IIOPin bindIOPin(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setPinValue(PinDescriptor pinDescriptor, boolean b) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean getPinValue(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public void setPinDirection(PinDescriptor pinDescriptor, boolean b){
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
    public void setServoPulseWidth(PinDescriptor pinDescriptor, int i){
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public double getAsDouble(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setPinDirection(PinDescriptor pinDescriptor, int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ILightSensor bindLightSensor(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int getLightSensorValue(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IToneGenerator bindToneGenerator(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void startTone(PinDescriptor pinDescriptor, int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IAccelerometer3D bindAccelerometer3D(PinDescriptor pinDescriptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setTone(PinDescriptor pinDescriptor, int i) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void enablePinChangeInterrupt(PinDescriptor pidx, boolean lowToHigh, boolean highToLow) {
    }

    public void disablePinChangeInterrupt(PinDescriptor pidx) {
    }

    public PinDescriptor[] waitForPinChange() {
        return new PinDescriptor[0];
    }

    public IIOPin[] getIOPins() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IOutputPin[] getOutputPins() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IScalarInput[] getScalarInputs() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
    
}
