/*
* Copyright (c) 2006 Sun Microsystems, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to 
* deal in the Software without restriction, including without limitation the 
* rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
* sell copies of the Software, and to permit persons to whom the Software is 
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in 
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
 **/       
package org.sunspotworld.demo.simspot.simsensorboard.io;

import com.sun.spot.sensorboard.io.IScalarInput;
import com.sun.spot.sensorboard.peripheral.IAccelerometer3D;
import com.sun.spot.sensorboard.peripheral.IAccelerometer3DThresholdListener;
import java.io.IOException;

/**
 * A simluation accelerometer that consists simply of three simulated 1D accelerometers.
 * @author randy
 */
public class SimAccelerometer3D implements IAccelerometer3D { 
    private SimAccelerometer x;
    private SimAccelerometer y;
    private SimAccelerometer z;
    
    private IAccelerometer3DThresholdListener[] listeners;

    private static final double ZERO_OFFSET = 472.0;
    private static final double GAIN = 188.0;
    
    /** Creates a new instance of SimAccelerometer3D */
    public SimAccelerometer3D() {
        listeners = new IAccelerometer3DThresholdListener[0];
    }
    
    public int getCurrentRange(){
        return 600; //not sure what this should be
    }
    
    public void setRange(int r){
        
    }
    
    public int[] getRanges(){
        return new int[] {600, 600, 600};
    }
     
    
    public void setXAxis(SimAccelerometer x) {
        this.x = x;
    }
     
    
    public void setYAxis(SimAccelerometer y) {
        this.y = y;
    }
     
    
    public void setZAxis(SimAccelerometer z) {
        this.z = z;
    }

    public IScalarInput getXAxis() {
        return x;
    }

    public IScalarInput getYAxis() {
        return y;
    }

    public IScalarInput getZAxis() {
        return z;
    }
    
    public double getAccelX() {
        return (x.getValue() - ZERO_OFFSET) / GAIN;
    }
    public double getAccelY() {
        return (x.getValue() - ZERO_OFFSET) / GAIN;
    }
    public double getAccelZ() {
        return (x.getValue() - ZERO_OFFSET) / GAIN;
    }
    public double getAccel() {
        double x = getAccelX();
        double y = getAccelY();
        double z = getAccelZ();
        return Math.sqrt(x*x + y*y + z*z);
    }
    public void setRestOffsets(){}
    public double getRelativeAccelX() { return getAccelX(); }
    public double getRelativeAccelY() { return getAccelY(); }
    public double getRelativeAccelZ() { return getAccelZ(); }
    public double getRelativeAccel()  { return getAccel(); }

    public double getTiltX() {
        return Math.asin(getAccelX() / getAccel());
    }
    public double getTiltY() {
        return Math.asin(getAccelY() / getAccel());
    }
    public double getTiltZ() {
        return Math.asin(getAccelZ() / getAccel());
    }

    public double getAccel(int i) throws IOException {
        if(i == 1) return getAccelX();
        if(i == 2) return getAccelY();
        if(i == 3) return getAccelZ();
        throw new RuntimeException("Cannot currently accelerate along t axis or other higher dimensions");
    }

    public double getRelativeAccel(int i) throws IOException {
        //Don't know what this means.'
        if(i == 1) return getAccelX();
        if(i == 2) return getAccelY();
        if(i == 3) return getAccelZ();
        throw new RuntimeException("Cannot currently accelerate along t axis or other higher dimensions");
    }

    public double getTilt(int i) throws IOException {
        if(i == 1) return getTiltX();
        if(i == 2) return getTiltY();
        if(i == 3) return getTiltZ();
        throw new RuntimeException("Cannot currently tilt along t axis or other higher dimensions");
    }

    public boolean supportsThresholdEvents() {
        return false;
    }

    public void addIAccelerometer3DThresholdListener(IAccelerometer3DThresholdListener iAccelerometer3DThresholdListener) {
    }

    public void removeIAccelerometer3DThresholdListener(IAccelerometer3DThresholdListener iAccelerometer3DThresholdListener) {
    }

    public IAccelerometer3DThresholdListener[] getIAccelerometer3DThresholdListeners() {
        return listeners;
    }

    public void setThresholds(int i, double d, double d0, boolean b) {
        throw new RuntimeException("Threasholding not enabled");
    }

    public double getLowThreshold(int i, boolean b) {
        throw new RuntimeException("Threasholding not enabled");
    }

    public double getHighThreshold(int i, boolean b) {
        throw new RuntimeException("Threasholding not enabled");
    }

    public void enableThresholdEvents(int i, boolean b) {
    }

    public boolean areThresholdEventsEnabled(int i) {
        return false;
    }
}