/*
 * Copyright  2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to technology embodied in the product that is
 * described in this document. In particular, and without limitation, these intellectual property rights may
 * include one or more of the U.S. patents listed at http://www.sun.com/patents and one or more additional patents
 * or pending patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software. Government users are subject to the Sun Microsystems, Inc.
 * standard license agreement and applicable provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun, Sun Microsystems, the Sun logo and
 * Java are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S. and other countries.
 *
 * Copyright  2007 Sun Microsystems, Inc. Tous droits rservs.
 *
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs  la technologie incorpore dans
 * le produit qui est dcrit dans ce document. En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists  l'adresse http://www.sun.com/patents
 * et un ou les brevets supplmentaires ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des tierces parties.
 * Sun, Sun Microsystems, le logo Sun et Java sont des marques de fabrique ou des marques dposes de Sun
 * Microsystems, Inc. aux Etats-Unis et dans d'autres pays.
 */

/*
 * MyTriColorLED.java
 *
 * Created on September 26, 2007, 4:15 PM
 */

package org.sunspotworld.demo;

import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.io.PinDescriptor;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.sensorboard.peripheral.LEDColor;

/**
 *
 * @author vgupta
 */
public class MyTriColorLED implements ITriColorLED {
    private static MyTriColorLED[] myleds = null;
    
    ITriColorLED realLED;
    int idx;
    int r, g, b;
    boolean on;
    
    /** Creates a new instance of MyTriColorLED */
    public MyTriColorLED(int index, ITriColorLED realLED) {
        this.realLED = realLED;
        idx = index;
        r = 0; 
        g = 0;
        b = 0;
        on = false;
    }

    public static ITriColorLED[] getLEDs(ITriColorLED[] leds) {
        if (myleds != null) return myleds;
        
        myleds = new MyTriColorLED[leds.length];
        for (int i = 0; i < leds.length; i++) {
            myleds[i] = new MyTriColorLED(i, leds[i]);
        }
        return myleds;
    }
    
    public void setRGB(int redRGB, int greenRGB, int blueRGB) {
        r = redRGB;
        g = greenRGB;
        b = blueRGB;
        setOn(on);
//        System.out.println("LED[" + idx + "].setRGB(" + r + ", " +
//                g + ", " + b + ") on=" + on);
    }

    public void setColor(LEDColor clr) {
        r = clr.red();
        g = clr.green();
        b = clr.blue();
        setOn(on);
//        System.out.println("LED[" + idx + "].setColor(" + r + ", " +
//                g + ", " + b + ") on=" + on);
    }

    public LEDColor getColor() {
        return new LEDColor(r, g, b);
    }

    public int getRed() {
        return r;
    }

    public int getGreen() {
        return g;
    }

    public int getBlue() {
        return b;
    }

    public PinDescriptor getIndex() {
        return null;
    }

    public void setOn() {
        setOn(true);
    }

    public void setOff() {
        setOn(false);
    }

    public void setOn(boolean on) {
//         System.out.println("LED[" + idx + "].setOn(" + r + ", " +
//                g + ", " + b + ") on=" + on);
        this.on = on;
        if (this.on) {
            realLED.setRGB(r, g, b);
            realLED.setOn();
        } else {
            realLED.setOff();
        }
    }

    public boolean isOn() {
        return on;
    }
    
}
