/*
 * TestPacketSniffer.java
 *
 * Created on March 12, 2007, 6:07 PM
 *
 * To change this template, choose Tools | Template Manager and locate this template
 * under the Java Classes. You can then make changes to the template in the Source Editor.
 */

package org.sunspotworld.demo;

import org.sunspotworld.util.*;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.peripheral.radio.*;
import com.sun.spot.io.j2me.radio.*;
import com.sun.spot.io.j2me.radiogram.*;
import com.sun.spot.util.*;

import java.io.*;
import javax.microedition.io.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

/**
 * The startApp method of this class is called by the VM to start the
 * application.
 *
 * The manifest specifies this class as MIDlet-N, which means it will not
 * be automaticlly selected for execution.
 *
 * @author Ron Goldman
 */
public class TestPacketSniffer extends MIDlet {

    protected void startApp() throws MIDletStateChangeException {
        System.out.println("Packet Sniffer Test Application");
        new BootloaderListener().start();
        Queue printQueue = new Queue();
        Queue freeQueue = new Queue();
        PacketSniffer sniffer = new PacketSniffer(printQueue, freeQueue);
        PacketPrinter printer = new PacketPrinter(printQueue, freeQueue);

        Thread printThread = new Thread(printer);
        Thread.currentThread().setPriority(Thread.MAX_PRIORITY - 1);
        printThread.setPriority(Thread.MAX_PRIORITY - 2);
        printThread.start();
        sniffer.readPackets();

    }
    
    protected void pauseApp() {
        // This will never be called by the Squawk VM
    }
    
    /**
     * Called if the MIDlet is terminated by the system.
     * I.e. if startApp throws any exception other than MIDletStateChangeException,
     * if the isolate running the MIDlet is killed with Isolate.exit(), or
     * if VM.stopVM() is called.
     * 
     * It is not called if MIDlet.notifyDestroyed() was called.
     *
     * @param unconditional If true when this method is called, the MIDlet must
     *    cleanup and release all resources. If false the MIDlet may throw
     *    MIDletStateChangeException  to indicate it does not want to be destroyed
     *    at this time.
     */
    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }
}
