/*
 * Count.java
 *
 * Created on October 8, 2006, 12:15 AM
 */

package org.sunspotworld;

import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.io.j2me.radiostream.*;
import com.sun.spot.io.j2me.radiogram.*;
import com.sun.spot.sensorboard.peripheral.LEDColor;
import com.sun.spot.util.*;

import java.io.*;
import javax.microedition.io.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

/**
 * A simple MIDlet that uses the left switch (SW1) to broadcast a message
 * to set the color of the LEDs of any receiving SPOTs and the right 
 * switch (SW2) to count in binary in its LEDs.
 *
 * Messages received from the other SPOTs control the LEDs of this SPOT.
 */
public class BroadcastCount extends MIDlet implements ISwitchListener {

    private static final int CHANGE_COLOR = 1;
    private static final int CHANGE_COUNT = 2;

    private ITriColorLED leds[] = EDemoBoard.getInstance().getLEDs();
    private ISwitch switches[] = EDemoBoard.getInstance().getSwitches();
    private int count = -1;
    private int color = 0;
    private LEDColor[] colors = { LEDColor.RED, LEDColor.GREEN, LEDColor.BLUE };
    private RadiogramConnection tx = null;
    private Radiogram xdg;
    
    private void showCount(int count, int color) {
        for (int i = 7, bit = 1; i >= 0; i--, bit <<= 1) {
            if ((count & bit) != 0) {
                leds[i].setColor(colors[color]);
                leds[i].setOn();
            } else {
                leds[i].setOff();
            }
        }
    }
    
    private void showColor(int color) {
        for (int i = 0; i < 8; i++) {
            leds[i].setColor(colors[color]);
            leds[i].setOn();
        }
    }
    
    protected void startApp() throws MIDletStateChangeException {
        System.out.println("Broadcast Counter MIDlet");
        showColor(color);
        switches[0].addISwitchListener(this);
        switches[1].addISwitchListener(this);
        try {
            tx = (RadiogramConnection)Connector.open("radiogram://broadcast:123");
            xdg = (Radiogram)tx.newDatagram(20);
            RadiogramConnection rx = (RadiogramConnection)Connector.open("radiogram://:123");
            Radiogram rdg = (Radiogram)rx.newDatagram(20);
            while (true) {
                try {
                    rx.receive(rdg);
                    int cmd = rdg.readInt();
                    int newCount = rdg.readInt();
                    int newColor = rdg.readInt();
                    if (cmd == CHANGE_COLOR) {
                        System.out.println("Received packet from " + rdg.getAddress());
                        showColor(newColor);
                    } else {
                        showCount(newCount, newColor);
                    }
                } catch (IOException ex) {
                    System.out.println("Error receiving packet: " + ex);
                    ex.printStackTrace();
                }
            }
        } catch (IOException ex) {
            System.out.println("Error opening connections: " + ex);
            ex.printStackTrace();
        }
    }

    protected void pauseApp() {
        // This will never be called by the Squawk VM
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        // Only called if startApp throws any exception other than MIDletStateChangeException
    }

    public void switchReleased(ISwitch sw) {
        int cmd;
        if (sw == switches[0]) {
            cmd = CHANGE_COLOR;
            if (++color >= colors.length) { color = 0; }
            count = -1;
        } else {
            cmd = CHANGE_COUNT;
            count++;
        }
        try {
            xdg.reset();
            xdg.writeInt(cmd);
            xdg.writeInt(count);
            xdg.writeInt(color);
            tx.send(xdg);
        } catch (IOException ex)  {
            System.out.println("Error sending packet: " + ex);
            ex.printStackTrace();
        }
    }

    public void switchPressed(ISwitch sw) {
    }
}
