/*
 * Count.java
 *
 * Created on October 8, 2006, 12:15 AM
 */

package org.sunspotworld;

import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.io.j2me.radiostream.*;
import com.sun.spot.io.j2me.radiogram.*;
import com.sun.spot.sensorboard.peripheral.LEDColor;
import com.sun.spot.util.*;

import java.io.*;
import javax.microedition.io.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

/**
 * A simple MIDlet that uses the left switch (SW1) to set the color of the LEDs
 * and the right switch (SW2) to count in binary in the LEDs.
 */
public class Count extends MIDlet implements ISwitchListener {

    private ITriColorLED leds[] = EDemoBoard.getInstance().getLEDs();
    private ISwitch switches[] = EDemoBoard.getInstance().getSwitches();
    private int count = -1;
    private int color = 0;
    private LEDColor[] colors = { LEDColor.RED, LEDColor.GREEN, LEDColor.BLUE };
    
    private void showCount() {
        for (int i = 7, bit = 1; i >= 0; i--, bit <<= 1) {
            if ((count & bit) != 0) {
                leds[i].setOn();
            } else {
                leds[i].setOff();
            }
        }
    }
    
    protected void startApp() throws MIDletStateChangeException {
        System.out.println("Counter MIDlet");
        for (int i = 0; i < 8; i++) {
            leds[i].setColor(colors[color]);
            leds[i].setOn();
        }
        switches[0].addISwitchListener(this);
        switches[1].addISwitchListener(this);
        while (true) {
            Utils.sleep(1000);
        }
    }

    protected void pauseApp() {
        // This will never be called by the Squawk VM
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        // Only called if startApp throws any exception other than MIDletStateChangeException
    }

    public void switchReleased(ISwitch sw) {
        if (sw == switches[0]) {
            if (++color >= colors.length) { color = 0; }
            count = -1;
            for (int i = 0; i < 8; i++) {
                leds[i].setColor(colors[color]);
                leds[i].setOn();
            }
        } else {
            count++;
            showCount();
        }
    }

    public void switchPressed(ISwitch sw) {
    }
}
