/*
 * Sawtooth.java
 *
 * Created on August 31, 2007, 11:34 PM
 *
 * To change this template, choose Tools | Template Manager and locate this template
 * under the Java Classes. You can then make changes to the template in the Source Editor.
 */

package org.sunspotworld;

import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.io.j2me.radio.*;
import com.sun.spot.io.j2me.radiogram.*;
import com.sun.spot.util.Utils;

import java.io.*;
import javax.microedition.io.*;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

/**
 * A very simple MIDlet to turn on the LEDs one by one,
 * each brighter than the previous until they are all on.
 * Then all the LEDs are turned off and the cycle repeats.
 */
public class Sawtooth extends MIDlet {
    
    private ITriColorLED leds[] = EDemoBoard.getInstance().getLEDs();
    private ISwitch sw2 = EDemoBoard.getInstance().getSwitches()[EDemoBoard.SW2];
    protected void startApp() throws MIDletStateChangeException {
        System.out.println("Hello, sawtooth");
        while (sw2.isOpen()) {
            for (int i = 0; i < 8; i++) {
                int val = 32 * (i + 1);
                leds[i].setRGB(val, 0, val);
                leds[i].setOn();
                Utils.sleep(1000);
            }
            for (int i = 0; i < 8; i++) {
                leds[i].setOff();
            }
            Utils.sleep(1000);
        }
    }
    
    protected void pauseApp() {
        // This will never be called by the Squawk VM
    }
    
    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        // Only called if startApp throws any exception other than MIDletStateChangeException
    }
}
