/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LlamaAdaptive
extends Algorithm {
    LinkedList<PDF> probabilitydist = new LinkedList();
    double meanintertime = 0.0;
    double variance = 0.0;
    PDF distribution = new PDF();

    @Override
    public rechargeinfo runalgorithm(List presentinfo, boolean charging) throws IOException {
        rechargeinfo temp = new rechargeinfo();
        temp.dotask = false;
        temp.timeinterval = PropertyFileValues.defaulttime;
        if (charging) {
            FileWriter fw = new FileWriter(new File(String.valueOf(PropertyFileValues.destination_dir) + "/" + "Logger_" + String.valueOf(presentinfo.get(0)).substring(0, 10)), true);
            fw.write("\nNetwork Application");
            fw.write("\nPresent Battery at time " + String.valueOf(presentinfo.get(0)) + " is " + String.valueOf(presentinfo.get(2)));
            fw.write("\nDoing Task and changing network download to 1");
            fw.close();
            temp.brightnesslevel = 1.0;
            temp.dotask = true;
            return temp;
        }
        LinkedList<Bar> distribution = this.findhistogram(PropertyFileValues.archivefile, new Integer(String.valueOf(presentinfo.get(2))), new Long(String.valueOf(presentinfo.get(1))));
        double meanintertimehrs = this.meanintertime / 3600.0;
        double probability = 1.0 - PropertyFileValues.probassurance;
        double cdf = 0.0;
        double recharge = 0.0;
        LinkedList<Bar> cumulative = new LinkedList<Bar>();
        double prob = 0.0;
        int i = 0;
        while (i < distribution.size()) {
            Bar val = distribution.get(i);
            Bar valnew = new Bar(val.bin, prob += val.val);
            cumulative.add(valnew);
            ++i;
        }
        i = 0;
        while (i < cumulative.size() - 1) {
            Bar firstprob = (Bar)cumulative.get(i);
            Bar secondprob = (Bar)cumulative.get(i + 1);
            System.out.println("*** " + firstprob.val + " " + secondprob.val);
            if (probability >= firstprob.val && probability <= secondprob.val) {
                recharge = firstprob.bin;
                break;
            }
            if (probability >= firstprob.val) {
                recharge = firstprob.bin;
            }
            ++i;
        }
        System.out.println(" " + recharge + " " + this.variance);
        double amtenergy = recharge / 100.0 * new Double(String.valueOf(presentinfo.get(3)));
        System.out.println("Amount of Energy " + amtenergy + " " + recharge + " " + this.meanintertime / 3600.0);
        double wattpower = amtenergy / (this.meanintertime / 3600.0);
        System.out.println("In MAH " + wattpower);
        FileReader fr = new FileReader(new File(PropertyFileValues.appenergyinfo));
        BufferedReader fread = new BufferedReader(fr);
        String line = fread.readLine();
        double lastdouble = 0.0;
        boolean found = false;
        while (line != null) {
            StringTokenizer tok = new StringTokenizer(line);
            double level = new Double(tok.nextToken());
            double energy = new Double(tok.nextToken());
            if (energy >= wattpower) break;
            lastdouble = level;
            line = fread.readLine();
        }
        fread.close();
        System.out.println("LASTDOUBLE " + lastdouble + " " + wattpower);
        if (lastdouble == 0.0) {
            temp.dotask = true;
            temp.brightnesslevel = 0.25;
            temp.timeinterval = PropertyFileValues.defaulttime;
        } else {
            temp.dotask = true;
            temp.timeinterval = PropertyFileValues.defaulttime;
            temp.brightnesslevel = lastdouble;
        }
        FileWriter fw = new FileWriter(new File(String.valueOf(PropertyFileValues.destination_dir) + "/" + "Logger_" + String.valueOf(presentinfo.get(0)).substring(0, 10)), true);
        fw.write("\nPresent Battery at time " + String.valueOf(presentinfo.get(0)) + " is " + String.valueOf(presentinfo.get(2)));
        int i2 = 0;
        while (i2 < distribution.size()) {
            Bar temp1 = distribution.get(i2);
            fw.write("\n " + temp1.bin + " " + temp1.val);
            ++i2;
        }
        if (temp.dotask) {
            fw.write("\nDoing Task and changing network download to " + temp.brightnesslevel);
        } else {
            fw.write("\nNot doing task");
        }
        fw.write("\nMean inter recharge time " + this.meanintertime);
        fw.write("\nEnergy left at recharge " + amtenergy);
        fw.close();
        return temp;
    }

    private LinkedList<Bar> findhistogram(String filename, int percentage, long presenttime) throws IOException {
        int onac;
        Integer val;
        StringTokenizer str;
        String line;
        long sectime;
        int charge;
        int lastonac;
        BufferedReader fr;
        FileReader f;
        String datafile;
        System.out.println(filename);
        File dir1 = new File(PropertyFileValues.logfiles);
        String[] log_list = dir1.list();
        File directory = new File(filename);
        String[] file_list = directory.list();
        LinkedList<Long> time = new LinkedList<Long>();
        Histogram hist = new Histogram(0.0, 100.0, 20);
        int i = 0;
        while (i < file_list.length) {
            datafile = String.valueOf(filename) + "/" + file_list[i];
            f = new FileReader(new File(datafile));
            fr = new BufferedReader(f);
            lastonac = 1;
            charge = 0;
            sectime = 0L;
            line = fr.readLine();
            while (line != null) {
                str = new StringTokenizer(line);
                if (line.contains("2007") || line.contains("2006") && str.countTokens() == 6) {
                    line = fr.readLine();
                    sectime = new Long(line);
                }
                if (line.contains("battery")) {
                    str.nextToken();
                    val = (int)new Integer(str.nextToken());
                    if (val <= 100) {
                        charge = val;
                        time.add(sectime);
                    }
                }
                if (line.contains("onAC")) {
                    str.nextToken();
                    val = new Integer(str.nextToken());
                    onac = val;
                    if (onac == 1 && lastonac == 0) {
                        hist.addelement(charge);
                    }
                    lastonac = onac;
                }
                line = fr.readLine();
            }
            ++i;
        }
        i = 0;
        while (i < log_list.length) {
            datafile = String.valueOf(PropertyFileValues.logfiles) + "/" + log_list[i];
            f = new FileReader(new File(datafile));
            fr = new BufferedReader(f);
            lastonac = 1;
            charge = 0;
            sectime = 0L;
            line = fr.readLine();
            while (line != null) {
                str = new StringTokenizer(line);
                if (line.contains("2007") || line.contains("2006") && str.countTokens() == 6) {
                    line = fr.readLine();
                    sectime = new Long(line);
                }
                if (line.contains("battery")) {
                    str.nextToken();
                    val = (int)new Integer(str.nextToken());
                    if (val <= 100) {
                        charge = val;
                        time.add(sectime);
                    }
                }
                if (line.contains("onAC")) {
                    str.nextToken();
                    val = new Integer(str.nextToken());
                    onac = val;
                    if (onac == 1 && lastonac == 0) {
                        System.out.println("Charge " + charge);
                        hist.addelement(charge);
                    }
                    lastonac = onac;
                }
                line = fr.readLine();
            }
            ++i;
        }
        System.out.println("Percentage of battery now :  " + percentage);
        LinkedList<Object> distribution = new LinkedList();
        distribution = hist.distributionlessthanapoint(percentage);
        double mean = 0.0;
        int i2 = 0;
        while (i2 < distribution.size()) {
            Bar temp = (Bar)distribution.get(i2);
            mean += temp.bin * temp.val;
            ++i2;
        }
        this.variance = 0.0;
        System.out.println(" " + mean);
        i2 = 0;
        while (i2 < distribution.size()) {
            Bar temp = (Bar)distribution.get(i2);
            System.out.println("00  " + temp.bin + " " + mean + " " + temp.val);
            this.variance += (temp.bin - mean) * (temp.bin - mean) * temp.val;
            ++i2;
        }
        System.out.println("Variance " + this.variance);
        this.variance = Math.sqrt(this.variance);
        i2 = 0;
        while (i2 < time.size() - 1) {
            double difference = (Long)time.get(i2 + 1) - (Long)time.get(i2);
            if (difference > 0.0) {
                this.meanintertime += (difference /= 1000.0);
            }
            ++i2;
        }
        this.meanintertime /= (double)time.size();
        double lastrechargetime = (Long)time.get(time.size() - 1) / 1000L;
        double difference = (double)presenttime / 1000.0 - lastrechargetime;
        System.out.println("difference " + difference + " " + this.meanintertime);
        return distribution;
    }
}

