/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacSystemParameters
extends SystemParameters {
    public int batteryremaining;
    public int batteryfull;

    public double getCpu() {
        String result = new String();
        try {
            Runtime rtime = Runtime.getRuntime();
            String[] commands = new String[]{"/bin/sh", "-c", "iostat -c 5 |tail -3"};
            Process proc = rtime.exec(commands);
            proc.waitFor();
            DataInputStream in = new DataInputStream(proc.getInputStream());
            byte[] bytes = new byte[128];
            while (in.available() > 0) {
                in.read(bytes);
                result = result.concat(new String(bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] results = result.trim().split("\n");
        double[] nums = new double[results.length];
        if (results.length < 3) {
            return -1.0;
        }
        int i = 0;
        while (i < 3) {
            String[] tokens = results[i].trim().split(" ");
            try {
                int tmpnum = Integer.parseInt(tokens[tokens.length - 1]);
                nums[i] = tmpnum;
            }
            catch (NumberFormatException nfe) {
                nums[i] = 0.0;
            }
            ++i;
        }
        return 100.0 - this.getMedian(nums);
    }

    @Override
    public int getBatteryRemaining() {
        String result = new String();
        try {
            Runtime rtime = Runtime.getRuntime();
            String[] commands = new String[]{"/bin/sh", "-c", "system_profiler SPPowerDataType|grep Capacity"};
            Process proc = rtime.exec(commands);
            proc.waitFor();
            DataInputStream in = new DataInputStream(proc.getInputStream());
            byte[] bytes = new byte[128];
            while (in.available() > 0) {
                in.read(bytes);
                result = result.concat(new String(bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int full = 0;
        int remaining = 0;
        String[] results = result.split("\n");
        if (results.length >= 2) {
            if (results[0].trim().startsWith("Full Charge")) {
                String[] fullstr = results[0].split(":");
                if (fullstr.length != 2) {
                    return -1;
                }
                try {
                    this.batteryfull = full = Integer.parseInt(fullstr[1].trim());
                }
                catch (NumberFormatException nfe) {
                    return -1;
                }
            }
            if (results[1].trim().startsWith("Remaining Capacity")) {
                String[] remainstr = results[1].split(":");
                if (remainstr.length != 2) {
                    return -1;
                }
                try {
                    this.batteryremaining = remaining = Integer.parseInt(remainstr[1].trim());
                }
                catch (NumberFormatException nfe) {
                    return -1;
                }
            }
            return (int)((double)remaining / (double)full * 100.0);
        }
        return 255;
    }

    @Override
    public int getAc() {
        String result = new String();
        try {
            Runtime rtime = Runtime.getRuntime();
            String[] commands = new String[]{"/bin/sh", "-c", "system_profiler SPPowerDataType|grep Connected"};
            Process proc = rtime.exec(commands);
            proc.waitFor();
            DataInputStream in = new DataInputStream(proc.getInputStream());
            byte[] bytes = new byte[128];
            while (in.available() > 0) {
                in.read(bytes);
                result = result.concat(new String(bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] results = result.trim().split(":");
        if (results.length == 2) {
            if (results[1].trim().equalsIgnoreCase("Yes")) {
                return 1;
            }
            if (results[1].trim().equalsIgnoreCase("No")) {
                return 0;
            }
        }
        return 255;
    }

    public String getMACAddress() {
        String result = new String();
        try {
            Runtime rtime = Runtime.getRuntime();
            String[] commands = new String[]{"/bin/sh", "-c", "system_profiler SPNetworkDataType | grep 'MAC Address'"};
            Process proc = rtime.exec(commands);
            proc.waitFor();
            DataInputStream in = new DataInputStream(proc.getInputStream());
            byte[] bytes = new byte[128];
            while (in.available() > 0) {
                in.read(bytes);
                result = result.concat(new String(bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] results = result.trim().split("\n");
        String[] new_results = results[0].trim().split(" ");
        return new_results[2];
    }

    @Override
    public List<Comparable> Scheduler() {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        list.add((Comparable)((Object)this.getDate()));
        list.add(Long.valueOf(this.getDateInMilliseconds()));
        list.add(Integer.valueOf(this.getBatteryRemaining()));
        list.add(Integer.valueOf(this.batteryfull));
        list.add(Integer.valueOf(this.batteryremaining));
        list.add(Integer.valueOf(this.getAc()));
        list.add((Comparable)((Object)this.getMACAddress()));
        return list;
    }
}

