// package Learning;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class LearningTool
{
  public WindowsSystemParameters sysparams = new WindowsSystemParameters();

  public NetworkTask networkapp = new NetworkTask();

  public LearningTool ()
  {

  }

  public boolean learnenergypattern ()
      throws IOException, InterruptedException
  {
    //double brightness = 0;
    // XXX val is not being reset in this method. is it true throughout
    boolean val = true;
    double baseline = 0;

    // Learn the energy for the brightness values
    SystemParametersBean paramsbefore = sysparams.Scheduler();
    networkapp.runapplication(0.25,120000);
    SystemParametersBean paramsafter = sysparams.Scheduler();

    FileWriter fw = new FileWriter(new File(PropertyFileValues.appenergyinfo));

    // XXX what is baseline for? what is value for? what are the difference?
    baseline =
        new Double(String.valueOf(paramsbefore.getBatteryCapRemaining())).doubleValue()
            - new Double(String.valueOf(paramsafter.getBatteryCapRemaining())).doubleValue();

    System.out.println("Baseline " + baseline);

    for (int i = 2; i <= 4; i++)
    {
      double value = 0;
      paramsbefore = sysparams.Scheduler();
      networkapp.runapplication(i * 0.25,120000);
      paramsafter = sysparams.Scheduler();
      // value?
      value =
          new Double(String.valueOf(paramsbefore.getBatteryCapRemaining())).doubleValue()
              - new Double(String.valueOf(paramsafter.getBatteryCapRemaining())).doubleValue();

      System.out.println("Value  " + value);

      double actconsumption = (value - baseline) * 30;

      if (actconsumption > 0)
      {
        fw.write(" " + i * 0.25 + " " + actconsumption + "\n");
      }
      else
      {
        fw.close();

        return val;
      }
      System.out.println("Mode " + i * 0.25 + " " + actconsumption);
    }
    fw.close();

    return val;
  }
}
