// package SystemParameters;
import java.util.ArrayList;
import java.util.List;

public class WindowsSystemParameters
    extends SystemParameters
{
  public native double getCpu ();

  public native int getBatteryRemaining ();

  public native int getAc ();

  public native double getDisk ();

  public native double getIdleTime ();

  public native String getMACAddress ();

  public native long getBatteryCapRemaining ();

  public native long getMaxBatteryCap ();

  /**public List Scheduler ()
  {
    List<Comparable> list = new ArrayList<Comparable>();
    list.add(getDate());
    list.add(getDateInMilliseconds());
    list.add(getBatteryRemaining());

    // add full energy capacitys
    list.add(getMaxBatteryCap());
    list.add(getBatteryCapRemaining());
    list.add(getAc());
    list.add(new String(getMACAddress()));
    // System.out.println(list);

    return list;
  }**/
  
  public SystemParametersBean Scheduler()
  {
    SystemParametersBean bean = new SystemParametersBean();
    
    bean.setDate(getDate());
    bean.setDateInMilliseconds(getDateInMilliseconds());
    bean.setBatteryRemaining(getBatteryRemaining());
    
    //set full energy capacitys
    bean.setMaxBatteryCap(getMaxBatteryCap());
    bean.setBatteryCapRemaining(getBatteryCapRemaining());
    bean.setAc(getAc());
    bean.setMACAddress(new String(getMACAddress()));
    
    return bean;
  }
}
