//package PropertyHandler;

import java.io.File;



/*
 * Reads in values from the properties file
 */
public class PropertyFileValues {

	public static String address;
	public static String destination_dir;
	public static String install_dir;
	public static String llamaserver;
	public static String registrationid;
	public static String pdf_recharges;
	public static String appenergyinfo;
	public static String [] file_list;
	public static double probassurance;
	public static String archivefile;
	public static long defaulttime;
	public static String logfiles;
    public static long sleepinterval;
	
	public PropertyFileValues(String serverAddress, String outputDirectory, 
			String llamaServer, String registrationId,String cdf_recharges,String appenergyinfo
			, String probability,String archive,long defaulttime,
			String logfiles, long sleepinterval)
	{
	 this.setServerAddress(serverAddress);
	 this.setLlamaServer(llamaServer);
	 this.setOutputDirectory(outputDirectory);
	 this.setRegistrationId(registrationId);
	 PropertyFileValues.pdf_recharges = cdf_recharges;
	 PropertyFileValues.appenergyinfo = appenergyinfo;
	 PropertyFileValues.probassurance = new Double(probability).doubleValue();
	 PropertyFileValues.archivefile = archive;
	 PropertyFileValues.defaulttime = defaulttime;
	 PropertyFileValues.logfiles = logfiles;
	 PropertyFileValues.sleepinterval = sleepinterval;
	}
	
	
	public void initialize(){
		address=this.serverAddress;
		destination_dir=this.outputDirectory;
		install_dir=this.installDirectory;
		file_list=getFileList();
		llamaserver=this.llamaServer;
		registrationid=this.registrationId;
		makeDir(destination_dir);
		makeDir(destination_dir+"Archive");
	}

	//makes the archive directory
	private void makeDir(String dir_name){
		File f = new File(dir_name);
		f.mkdir();
	}
	
	//gets the list of files in the data directory
	public String[] getFileList(){
		File dir = new File(destination_dir);
		return dir.list();
	}



	/*******************Setters and Getters******************/
	protected String serverAddress;
	protected String outputDirectory;
	protected String installDirectory;
	protected String llamaServer;
	protected String registrationId;
	protected String lastDate;

	public String getServerAddress() {
		return serverAddress;
	}

	public void setServerAddress(String serverAddress) {
		this.serverAddress = serverAddress;
	}

	public String getOutputDirectory() {
		return outputDirectory;
	}

	public void setOutputDirectory(String outputDirectory) {
		this.outputDirectory = outputDirectory;
	} 
	
	public String getInstallDirectory() {
		return installDirectory;
	}

	public void setInstallDirectory(String installDirectory) {
		this.installDirectory = installDirectory;
	} 


	public String getLlamaServer() {
		return llamaServer;
	}

	public void setLlamaServer(String llamaServer) {
		this.llamaServer = llamaServer;
	}

	public String getRegistrationId() {
		return registrationId;
	}

	public void setRegistrationId(String registrationId) {
		this.registrationId = registrationId;
	}

	public String getLastDate() {
		return lastDate;
	}

	public void setLastDate(String lastDate) {
		this.lastDate = lastDate;
	}
}
