import java.io.FileInputStream;
import java.util.Properties;

/*
 * Takes as input the client value properties file and creates a new client
 */

public class Client
{
  public String propertiesFile = null;

  public SystemProfiler systemprofiler = null;

  public MacSystemParameters systemparameters = null;

  public FileHandler filehandler = null;

  public PropertyFileValues propertyfilevalues = null;

  public ClientServerSync clientserversync = null;

  // Main method
  public static void main (String[] args)
  {
  //Create class instance
    System.loadLibrary("wtimerlib");
    System.loadLibrary("suspend");
    System.loadLibrary("WinSysapp");
    new Client("ClientValues.properties");
  }

  // Sets-up the beans and runs them
  public Client (String parameterFileName)
  {
    setupObjects(parameterFileName);

    try
    {
      propertyfilevalues.initialize();
      systemprofiler.getSystemProfile();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  // Creates the objects
  void setupObjects (String parameterFileName)
  {
    try
    {
      this.propertiesFile = parameterFileName;
      Properties defaultProp = new Properties();
      FileInputStream in = new FileInputStream(this.propertiesFile);
      System.out.println("propertiesFile " + this.propertiesFile);
      defaultProp.load(in);
      in.close();
      System.out.println("sleeptime " + defaultProp.getProperty("sleeptime"));
      systemprofiler =
          new SystemProfiler(new Integer(defaultProp.getProperty("sleeptime"))
              .intValue());
      propertyfilevalues = new PropertyFileValues(defaultProp);
      System.out.println("The log file "
          + defaultProp.getProperty("logfiles"));
    }
    catch (Exception e)
    {
      e.printStackTrace();
      System.out.println("Exception :" + e.getCause() + " :: "
          + e.getStackTrace());
    }
  }
}
