// package Learning;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LearningTool
{
  public WindowsSystemParameters sysparams = new WindowsSystemParameters();

  public PodcastTask podcastapp = new PodcastTask();
  
  public LearningTool ()
  {

  }

  public void learnenergypattern ()
      throws IOException, InterruptedException
  {
    double baseline = 0;

    // Learn the energy for the brightness values
    SystemParametersBean paramsbefore = sysparams.Scheduler();
    podcastapp.runapplication(1.0, 120000);
    SystemParametersBean paramsafter = sysparams.Scheduler();

    File file = new File(PropertyFileValues.appenergyinfo);
    FileWriter fw = new FileWriter(new File(PropertyFileValues.appenergyinfo));
    System.out.println("appenergyinfor path is " + file.getCanonicalPath());

    /**
     * So the application learns the amount of energy used by the podcast task 
     * application at different size categories (1, 2, 3, 4). Now the amount 
     * of energy consumed by the application is relative to some baseline. 
     * So baseline is the amount of energy consumed at category 1 and 
     * value gives us the energy at 2, 3 and 4 and the difference between the 
     * two gives you the excess energy consumed at 2, 3, 4.
     * 
     */
    baseline =
        new Double(String.valueOf(paramsbefore.getBatteryCapRemaining()))
            .doubleValue()
            - new Double(String.valueOf(paramsafter.getBatteryCapRemaining()))
                .doubleValue();

    System.out.println("Baseline " + baseline);
    
    for (int i = 2; i <= 4; i++)
    {
      double value = 0;
      paramsbefore = sysparams.Scheduler();
      podcastapp.runapplication(i * 1.0, 120000);
      paramsafter = sysparams.Scheduler();
      value =
          new Double(String.valueOf(paramsbefore.getBatteryCapRemaining()))
              .doubleValue()
              - new Double(String.valueOf(paramsafter.getBatteryCapRemaining()))
                  .doubleValue();

      System.out.println("Value  " + value);

      double actconsumption = (value - baseline) * 30;

      System.out.println("actconsumption is " + actconsumption);
      if (actconsumption > 0.0)
      {
        fw.write(" " + i * 1 + " " + actconsumption + "\n");
      }
      else
      {
        fw.close();
      }
      System.out.println("Mode " + i * 1 + " " + actconsumption);
    }
    fw.close();

  }
}
