// package SystemParameters;
import java.io.DataInputStream;

/*
 * Retrieve System parameters for the Mac client
 */

public class MacSystemParameters
    extends SystemParameters
{
  public int batteryremaining;

  public int batteryfull;

  // retrieve cpu usage
  public double getCpu ()
  {
    String result = new String();
    try
    {
      Runtime rtime = Runtime.getRuntime();
      String[] commands =
      {
          "/bin/sh", "-c", "iostat -c 5 |tail -3"
      };
      Process proc = rtime.exec(commands);
      proc.waitFor();
      DataInputStream in = new DataInputStream(proc.getInputStream());
      byte[] bytes = new byte[128];

      while (in.available() > 0)
      {
        in.read(bytes);
        result = result.concat(new String(bytes));
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    String[] results = result.trim().split("\n");
    double[] nums = new double[results.length];
    int tmpnum;
    if (results.length < 3)
    {
      return -1;
    }
    // results.length should be three
    for (int i = 0; i < 3; i++)
    {

      String[] tokens = results[i].trim().split(" ");
      try
      {
        tmpnum = Integer.parseInt(tokens[tokens.length - 1]);
        nums[i] = tmpnum;
      }
      catch (NumberFormatException nfe)
      {
        nums[i] = 0;
      }
    }
    return(100 - getMedian(nums));
  }


  // Get Battery Remaining
  public int getBatteryRemaining ()
  {

    String result = new String();
    try
    {
      Runtime rtime = Runtime.getRuntime();
      String[] commands =
      {
          "/bin/sh", "-c", "system_profiler SPPowerDataType|grep Capacity"
      };
      Process proc = rtime.exec(commands);

      proc.waitFor();
      DataInputStream in = new DataInputStream(proc.getInputStream());

      byte[] bytes = new byte[128];

      while (in.available() > 0)
      {
        in.read(bytes);
        result = result.concat(new String(bytes));
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    int full = 0;
    int remaining = 0;

    String[] results = result.split("\n");

    if (results.length >= 2)
    {

      if (results[0].trim().startsWith("Full Charge"))
      {
        String[] fullstr = results[0].split(":");

        if (fullstr.length != 2)
        {
          return -1;
        }
        try
        {
          full = Integer.parseInt(fullstr[1].trim());
          this.batteryfull = full;
        }
        catch (NumberFormatException nfe)
        {
          return -1;
        }
      }

      if (results[1].trim().startsWith("Remaining Capacity"))
      {
        String[] remainstr = results[1].split(":");

        if (remainstr.length != 2)
        {
          return -1;
        }
        try
        {
          remaining = Integer.parseInt(remainstr[1].trim());
          this.batteryremaining = remaining;
        }
        catch (NumberFormatException nfe)
        {
          return -1;
        }
      }
      return (int) (((double) remaining) / full * 100);
    }
    return 255;
  }

  // Get power status - plugged in or not
  public int getAc ()
  {
    String result = new String();
    try
    {
      Runtime rtime = Runtime.getRuntime();
      String[] commands =
      {
          "/bin/sh", "-c", "system_profiler SPPowerDataType|grep Connected"
      };
      Process proc = rtime.exec(commands);

      proc.waitFor();
      DataInputStream in = new DataInputStream(proc.getInputStream());

      byte[] bytes = new byte[128];

      while (in.available() > 0)
      {
        in.read(bytes);
        result = result.concat(new String(bytes));
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    String[] results = result.trim().split(":");

    if (results.length == 2)
    {
      if (results[1].trim().equalsIgnoreCase("Yes"))
      {
        return 1;
      }
      else if (results[1].trim().equalsIgnoreCase("No"))
      {
        return 0;
      }
    }
    return 255;
  }


  // Get the MAC address
  public String getMACAddress ()
  {

    String result = new String();
    try
    {
      Runtime rtime = Runtime.getRuntime();
      String[] commands =
          {
              "/bin/sh", "-c",
              "system_profiler SPNetworkDataType | grep 'MAC Address'"
          };
      Process proc = rtime.exec(commands);

      proc.waitFor();
      DataInputStream in = new DataInputStream(proc.getInputStream());

      byte[] bytes = new byte[128];

      while (in.available() > 0)
      {
        in.read(bytes);
        result = result.concat(new String(bytes));
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
    String[] results = result.trim().split("\n");
    String[] new_results = results[0].trim().split(" ");
    return new_results[2];
  }

  /**public List<Comparable> Scheduler ()
  {
    List<Comparable> list = new ArrayList<Comparable>();
    list.add(getDate());
    list.add(getDateInMilliseconds());
    list.add(getBatteryRemaining());
    list.add(this.batteryfull);
    list.add(this.batteryremaining);
    list.add(getAc());
    list.add(getMACAddress());

    return list;
  }**/
  
  public SystemParametersBean Scheduler()
  {
    SystemParametersBean bean = new SystemParametersBean();
    
    bean.setDate(getDate());
    bean.setDateInMilliseconds(getDateInMilliseconds());
    bean.setBatteryRemaining(getBatteryRemaining());
    
    //set full energy capacitys
    bean.setMaxBatteryCap(this.batteryfull);
    bean.setBatteryCapRemaining(this.batteryremaining);
    bean.setAc(getAc());
    bean.setMACAddress(getMACAddress());
    
    return bean;
  }
}
