import java.io.IOException;

/**
 * Wake up the system, download podcast by size group and put the system
 * back into suspend mode if it was woken up automatically.
 *  
 * Size group:
 *  1: 0  - 25MB
 *  2: 26 - 50MB
 *  3: 51 - 75MB
 *  4: 76 - 100MB
 *  
 * @author Serene Chong
 * 
 */
public class PodcastTask
    extends Application
{
  public native int exeWTimer(long interval);
  
  public native void putStandby();

  public void runapplication (double params, long interval)
      throws IOException, InterruptedException
  {
    int result = 0;
    
    System.out.println("in podcasttask runapplication");
    
    if (params == 1.0)
    {
      System.out.println("params == 1");
      long intervalsleep = 0;
      
      while (intervalsleep < interval)
      {
        try
        {
          Runtime rt = Runtime.getRuntime();
          // Call native method to load ReadWTimer.java
          System.out.println("setting timer");
          // Set wake-up timer 
          result = exeWTimer(30000);
          System.out.println("Results from timer is " + result);
          Process proc =
              rt
                  .exec(new String[]
                  {
                      "cscript.exe",
                      "C:\\Documents and Settings\\Sami\\workspace\\LlamaApplications\\downloadPodcast.js",
                      "1"
                  });
          proc.waitFor(); 
          // If system wakes up automatically, put system back into suspend mode
          if (result == 1)
          {
            // Set wake-up timer 
            result = exeWTimer(120000);
            System.out.println("going into standby mode");
            putStandby();
          }
          intervalsleep += 120000;
        }
        catch (Throwable t)
        {
          t.printStackTrace();
        }
      }
    }
    else if (params == 2.0)
    {
      System.out.println("params == 2");
      long intervalsleep = 0;
      
      while (intervalsleep <= interval)
      { 
        try
        {
          Runtime rt = Runtime.getRuntime();
          // Call native method to load ReadWTimer.java
          System.out.println("setting timer");
          // Set wake-up timer 
          result = exeWTimer(30000);
          System.out.println("Results from timer is " + result);
          Process proc =
              rt
                  .exec(new String[]
                  {
                      "cscript.exe",
                      "C:\\Documents and Settings\\Sami\\workspace\\LlamaApplications\\downloadPodcast.js",
                      "2"
                  });
          proc.waitFor();
          // If system wakes up automatically, put system back into suspend mode
          if (result == 1)
          {
            // Set wake-up timer 
            result = exeWTimer(60000);
            System.out.println("going into standby mode");
            putStandby();
          }
          intervalsleep += 60000;
        }
        catch (Throwable t)
        {
          t.printStackTrace();
        }
      }
    }
    else if (params == 3.0)
    {
      System.out.println("params == 3");
      long intervalsleep = 0;
      
      while (intervalsleep <= interval)
      {
        try
        {
          Runtime rt = Runtime.getRuntime();
          // Call native method to load ReadWTimer.java
          System.out.println("setting timer");
          // Set wake-up timer 
          result = exeWTimer(30000);
          System.out.println("Results from timer is " + result);
          Process proc =
              rt
                  .exec(new String[]
                  {
                      "cscript.exe",
                      "C:\\Documents and Settings\\Sami\\workspace\\LlamaApplications\\downloadPodcast.js",
                      "3"
                  });
          proc.waitFor();
          // If system wakes up automatically, put system back into suspend mode
          if (result == 1)
          {
            // Set wake-up timer 
            result = exeWTimer(30000);
            System.out.println("going into standby mode");
            putStandby();
          }
          intervalsleep += 30000;
        }
        catch (Throwable t)
        {
          t.printStackTrace();
        }
      }
    }
    else if (params == 4.0)
    {
      System.out.println("params == 4");
      long intervalsleep = 0;
      
      while (intervalsleep <= interval)
      {
        try
        {
          Runtime rt = Runtime.getRuntime();
          // Call native method to load ReadWTimer.java
          System.out.println("setting timer");
          // Set wake-up timer 
          result = exeWTimer(30000);
          System.out.println("Results from timer is " + result);
          Process proc =
              rt
                  .exec(new String[]
                  {
                      "cscript.exe",
                      "C:\\Documents and Settings\\Sami\\workspace\\LlamaApplications\\downloadPodcast.js",
                      "4"
                  });
          proc.waitFor();
          // If system wakes up automatically, put system back into suspend mode
          if (result == 1)
          {
         // Set wake-up timer 
            result = exeWTimer(15000);
            System.out.println("going into standby mode");
            putStandby();
          }
          intervalsleep += 15000;
        }
        catch (Throwable t)
        {
          t.printStackTrace();
        }
      }
    }
    System.out.println("out of the ifs");
   
  }

}
