// package PropertyHandler;
import java.io.File;
import java.util.Properties;

/*
 * Reads in values from the properties file
 */
public class PropertyFileValues
{
  public static String address;

  public static String destination_dir;

  public static String install_dir;

  public static String llamaserver;

  public static String registrationid;

  public static String pdf_recharges;

  public static String appenergyinfo;

  public static String[] file_list;

  public static double probassurance;

  public static String archivefile;

  public static long defaulttime;

  public static String logfiles;

  public static long sleepinterval;

  public PropertyFileValues (Properties defaultProp)
  {
    setServerAddress(defaultProp.getProperty("connection_server"));
    setLlamaServer(defaultProp.getProperty("llama_server"));
    setOutputDirectory(defaultProp.getProperty("output_dir"));
    setRegistrationId(defaultProp.getProperty("register_id"));
    pdf_recharges = defaultProp.getProperty("pdf_recharges");
    appenergyinfo = defaultProp.getProperty("app_energyinfo");
    probassurance =
        new Double(defaultProp.getProperty("probability")).doubleValue();
    archivefile = defaultProp.getProperty("Archives");
    defaulttime = new Long(defaultProp.getProperty("sleeptime")).longValue(); //sleeptime
    logfiles = defaultProp.getProperty("logfiles");
    sleepinterval = new Long(defaultProp.getProperty("sleeptime")).longValue();
  }

  public void initialize ()
  {
    address = serverAddress;
    destination_dir = outputDirectory;
    install_dir = installDirectory;
    file_list = getFileList();
    llamaserver = this.llamaServer;
    registrationid = this.registrationId;
    makeDir(destination_dir);
    makeDir(destination_dir + "Archive");
  }

  // makes the archive directory
  private void makeDir (String dir_name)
  {
    File f = new File(dir_name);
    f.mkdir();
  }

  // gets the list of files in the data directory
  public String[] getFileList ()
  {
    File dir = new File(destination_dir);
    return dir.list();
  }

  /**
   * Setters and Getters
   */
  protected String serverAddress;

  protected String outputDirectory;

  protected String installDirectory;

  protected String llamaServer;

  protected String registrationId;

  protected String lastDate;

  public String getServerAddress ()
  {
    return serverAddress;
  }

  public void setServerAddress (String serverAddress)
  {
    this.serverAddress = serverAddress;
  }

  public String getOutputDirectory ()
  {
    return outputDirectory;
  }

  public void setOutputDirectory (String outputDirectory)
  {
    this.outputDirectory = outputDirectory;
  }

  public String getInstallDirectory ()
  {
    return installDirectory;
  }

  public void setInstallDirectory (String installDirectory)
  {
    this.installDirectory = installDirectory;
  }

  public String getLlamaServer ()
  {
    return llamaServer;
  }

  public void setLlamaServer (String llamaServer)
  {
    this.llamaServer = llamaServer;
  }

  public String getRegistrationId ()
  {
    return registrationId;
  }

  public void setRegistrationId (String registrationId)
  {
    this.registrationId = registrationId;
  }

  public String getLastDate ()
  {
    return lastDate;
  }

  public void setLastDate (String lastDate)
  {
    this.lastDate = lastDate;
  }
}
