//The function to get iTunes playlists. This is needed to get to the categories //under Library.
function getPlaylists(sources)
{
	var sourcesCount = sources.Count;
	var source = '';
	var sourceKind = '';
	var i;
	var playlists;
	
	for (i = 1; i <= sources.Count; i++)
	{
		source = sources.Item(i);
		sourceKind = source.Kind;
		//sourceKind 1 is the library playlist
		if (sourceKind == 1)
		{
			playlists = source.Playlists;
		}
	}
	return playlists;
}//End of getPlaylists function

//The function to check whether the current downloading podcast is in the //Recently Added playlist. If it is, the podcast is finished downloaded.
function checkRecentlyAdded(sources, podName)
{
	var j;
	var playlists = getPlaylists(sources);
	var downloaded = false;
	
	for (j = 1; j <= playlists.Count; j++)
	{
		var playlist = playlists.Item(j);
		var name = playlist.Name;
		if (name == "Recently Added")
		{
		  var recTracks = playlist.Tracks;
		  var n;
		  for (n = 1; n <= recTracks.Count; n++)
		  {
			  var recItem = recTracks.Item(n);
			  if (recItem.Name == podName)
			  {
				  downloaded = true;
			  }
		  }
		}
	}
	return downloaded;
}//End of checkRecentlyAdded function

//Determine size of podcast
function getPodToDwld(podtracks, value)
{
	//WScript.echo("value " + value);
	switch(value)
	{
	case "1":
		podtrack = dwldSize(podtracks, value, false);
		return podtrack;
		break;
	case "2":
		//WScript.echo("enter case 2");
		podtrack = dwldSize(podtracks, value, false);
		return podtrack;
		break;
	case "3":
		//WScript.echo("enter case 3");
		podtrack  = dwldSize(podtracks, value, false);
		return podtrack;
		break;
	case "4":
		//WScript.echo("enter case 4");
		podtrack = dwldSize(podtracks, value, true);
		return podtrack;
		break;
	default:
		WScript.echo("no value given");
	}
}//End of getPodToDwld function

//Get appropriate podcast
function dwldSize(podtracks, value, specialcase)
{
	var k;
	
	if (value != 0)
	{
		var startsize = (value - 1) * 25000000;
		var endsize = value * 25000000;
	
		for (k = 1; k <= podtracks.Count; k++)
		{
			var podtrack = podtracks.Item(k);
			if ((!specialcase) && (podtrack.url != null) && (podtrack.size > startsize) && (podtrack.size <= endsize))
			{	
				return podtrack;
			}
			else if ((specialcase) && (podtrack.url != null) && (podtrack.size > startsize))
			{
				return podtrack;
			}
		}
		return dwldSize(podtracks, value - 1, false);
	}
	else
	{
		return null;
	}
}//End of dwldSize function

//Main program
var iTunesApp = WScript.CreateObject("iTunes.Application");
var sources = iTunesApp.Sources;
var windows = iTunesApp.Windows;
var window = '';
var windowKind = '';
//podcast that is being downloaded
var podName = '';  

//Minimize iTunes window
var window = windows.Item(1);
window.Minimized = true;

var playlists = getPlaylists(sources);
iTunesApp.updatePodcastFeeds();

var j;
for (j = 1; j <= playlists.Count; j++)
{
	var playlist = playlists.Item(j);
	var name = playlist.Name;
	//Only want to look at podcasts
	if (name == "Podcasts")
	{
		var podtracks = playlist.Tracks;
		var podtrack = getPodToDwld(podtracks, WScript.Arguments(0));
		//Download podcast with URL
		if (podtrack != null)
		{
			podName = podtrack.Name;
			podtrack.downloadPodcastEpisode();
			var downloaded = false;
			var d1 = new Date();
			var dtBefore = d1.getTime();
			while (downloaded != true)
			{
				downloaded = checkRecentlyAdded(sources, podName);
			}
			var d2 = new Date();
			var dtAfter = d2.getTime();
			var downloadTime = dtAfter - dtBefore;
			WScript.echo("download time is " + downloadTime);
		}
	}
}
