#define _WIN32_WINNT 0x0501  // for Windows XP
#include "PodcastTask.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

JNIEXPORT jint JNICALL Java_PodcastTask_exeWTimer(JNIEnv * env, jobject jobj, jlong interval)
{
    HANDLE hTimer = NULL;
    LARGE_INTEGER liDueTime;
    liDueTime.QuadPart = (-10000) * interval;
	 
    // Create a waitable timer.
    hTimer = CreateWaitableTimer(NULL, TRUE, "WaitableTimer");
    if (NULL == hTimer)
    {
        return 11;
    }
	 
    // Set a timer to wait for 10 seconds.
    if (!SetWaitableTimer(hTimer, &liDueTime, 0, NULL, NULL, TRUE))
    {
        return 12;
    }

    // Wait for the timer.
    if (WaitForSingleObject(hTimer, INFINITE) != WAIT_OBJECT_0)
    {
		  return 13;
    }
    else 
    {
         printf("Timer was signaled.\n");
         if (system(NULL))
         {
               puts ("Ok");
					// The system woke up automatically or woke up by user events
					if (IsSystemResumeAutomatic())
					{
						return 1;
					}
					else
					{
						return 0;
					}
         }
         else 
         {     
               exit (1);
         }
    }

    return 10;
}
