import java.io.FileInputStream;
import java.util.Properties;


/*
 * Gets Beans from the SpringClient and runs the Client
 */

public class Client{

	public String propertiesFile = null;
	public SystemProfiler systemprofiler = null;
	public MacSystemParameters systemparameters = null;
	public FileHandler filehandler = null;
	public PropertyFileValues propertyfilevalues = null;
	public ClientServerSync clientserversync = null;

	//Main method
	public static void main(String[] args) {
		new Client("ClientValues.properties");
	}


	//Sets-up the beans and runs them
	public Client(String parameterFileName){

		setupObjects(parameterFileName);

		try
		{
			propertyfilevalues.initialize();
			systemprofiler.getSystemProfile();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

	}


	//Creates the objects
	void setupObjects(String parameterFileName) {

		try{	
			this.propertiesFile = parameterFileName;
			Properties defaultProp = new Properties();
			FileInputStream in = new FileInputStream(this.propertiesFile);
			defaultProp.load(in);
			in.close();
			systemprofiler = new SystemProfiler(new Integer(defaultProp.getProperty("sleeptime")).intValue());
			propertyfilevalues = new PropertyFileValues(defaultProp.getProperty("connection_server"),defaultProp.getProperty("output_dir")
					,defaultProp.getProperty("llama_server"),defaultProp.getProperty("registration_id"));
	     }
		catch (Exception e)
		{
		 e.printStackTrace();		
		 System.out.println("Exception :" + e.getCause()	+ " :: " + e.getStackTrace());
		}
		System.out.println("PropertiesFile = " + this.propertiesFile);
	}

}
