import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

import javax.swing.*;

public class OptionFrame extends JPanel implements ItemListener,PropertyChangeListener,ActionListener{

	JCheckBox others,rtr,ctr,location,limited,low,docking; 

	static String filename;
	static Vector  surveyresults = new Vector();
	JLabel initquestion;
	static JFrame  frame;
	JPanel checkPanel;	
	String textbox = "";
	private String question = "Why are you charging the system ? Select all that apply";
	private JLabel rateLabel;
	private JTextField othertext;
	
public OptionFrame()
{
	    super(new BorderLayout());
	
	
	    initquestion = new JLabel(question);
	    
	    surveyresults.removeAllElements();
	    rtr = new JCheckBox("Reminded by the system to recharge");
	    rtr.setMnemonic(KeyEvent.VK_C); 
	    rtr.setSelected(false);

	    ctr = new JCheckBox("It is convenient to charge at this time of the day");
	    ctr.setMnemonic(KeyEvent.VK_G); 
	    ctr.setSelected(false);

	    location = new JCheckBox("It is convenient to charge at this location");
	    location.setMnemonic(KeyEvent.VK_H); 
	    location.setSelected(false);

	    limited = new JCheckBox("Concerned with limited charging opportunities ahead");
	    limited.setMnemonic(KeyEvent.VK_T); 
	    limited.setSelected(false);


	    low = new JCheckBox("Battery was low");
	    low.setMnemonic(KeyEvent.VK_T); 
	    low.setSelected(false);

	    

	    docking = new JCheckBox("I am using the system with the docking station");
	    docking.setMnemonic(KeyEvent.VK_T); 
	    docking.setSelected(false);

	    
	    others = new JCheckBox("Other (type in Optional below)");
	    others.setMnemonic(KeyEvent.VK_T);
	    others.setSelected(false);
	    
	    othertext = new JTextField();
	    othertext.setColumns(10);
	    othertext.addActionListener(this);
	    
	    
	    
	    
	    JButton b = new JButton("Close");
	    b.setMnemonic(KeyEvent.VK_E);
	    b.setActionCommand("enable");
	    b.setEnabled(true);
	    
	    
	    //Register a listener for the check boxes.
	    ctr.addItemListener(this);
	    rtr.addItemListener(this);
	    location.addItemListener(this);
	    limited.addItemListener(this);
	    low.addItemListener(this);
	    docking.addItemListener(this);
        b.addActionListener(this);
	    
	    //Put the check boxes in a column in a panel
        checkPanel = new JPanel(new GridLayout(0, 1));
        checkPanel.add(initquestion);
        checkPanel.add(ctr);
        checkPanel.add(rtr);
        checkPanel.add(location);
        checkPanel.add(limited);
        checkPanel.add(low);
        checkPanel.add(docking);
        checkPanel.add(others);
        checkPanel.add(othertext);
        checkPanel.add(b);
         
        
        add(checkPanel, BorderLayout.LINE_START);
        
        
}



public static void createAndShowGUI(String file_name) {
    //Create and set up the window.
	
	filename = file_name;
   frame = new JFrame("Llama Survey");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    //Create and set up the content pane.
    JComponent newContentPane = new OptionFrame();
    newContentPane.setOpaque(true); //content panes must be opaque
    frame.setContentPane(newContentPane);

    Toolkit tk = Toolkit.getDefaultToolkit ();
    
    // Get the screen dimensions.
    Dimension screen = tk.getScreenSize ();

    // And place it in center of screen.
    int lx =  (int) (screen.getWidth ()  * 3/8);
    int ly =  (int) (screen.getHeight () * 3/8);
    frame.setLocation (lx,ly);
    
    //Display the window.
    frame.pack();
    frame.setVisible(true);
    
    Timer timer = new Timer(60000, new ActionListener() {
    	public void actionPerformed(ActionEvent evt) {
    		frame.setVisible(false);
    	  }
     });
    timer.start();
}

public void itemStateChanged(ItemEvent e) {
    Object source = e.getItemSelectable();

    String line;
    if (source == rtr) {
        line = "Reminded by the system to recharge";
        surveyresults.add(line);
    } 
    else if (source == ctr) 
    {  
      line = "It is convenient to charge at this time of the day";
      surveyresults.add(line);
    } 
    else if (source == location) {
      line = "It is convenient to charge at this location";	
      surveyresults.add(line);
    } 
    else if (source == limited) 
    {
      line = "Concerned with limited charging opportunities ahead";
      surveyresults.add(line);
    }
    else if(source == low)
    {
      line = "Battery was low";
      surveyresults.add(line);
    }
    else if(source == docking)
    {
     line = "I am using the system with the docking station";	
     surveyresults.add(line);
    }
	
}

public void propertyChange(PropertyChangeEvent e) {
}

public void actionPerformed(ActionEvent e) {
	
	textbox += othertext.getText();
	
	frame.setVisible(false);
	frame.dispose();
	
	if(textbox.length() != 0)
	 surveyresults.add(textbox);
	
	writefile();
	
}


private void writefile()
{
	try
	{
	  FileOutputStream stream = new FileOutputStream(filename, true);
	  OutputStreamWriter out = new OutputStreamWriter(stream, "US-ASCII");
	  out.write("SURVEY RESULTS");
	  out.write("\n");
	for(int i=0;i<surveyresults.size();i++)
	{
		out.write((String)surveyresults.elementAt(i));
		out.write("\n");
	}
	out.close();
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
}

public static Vector returnsurvery()
{
	return surveyresults;
}
}
