
public class ImageManipulator {

	private String filename;
	private Picture p;
	
	public ImageManipulator(String filename) {
		this.filename = filename;
		this.p = new Picture(filename);
	}
	
	public void makeNegative() {
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j);
				newp.setPixel(i, j, new Pixel(255-pix.getRed(), 255-pix.getGreen(), 255-pix.getBlue()));
			}
		}
		newp.store("negative.gif");		
	}
	
	public void makeGreyscale() {
		//30% of the red value, 59% of the green value, and 11% of the blue value
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j);
				int val = (int)(pix.getRed()*.3) + (int)(pix.getGreen()*.59) + (int)(pix.getBlue()*.11);
				newp.setPixel(i, j, new Pixel(val, val, val));
			}
		}
		newp.store("greyscale.gif");		
		
	}
	
	public void flipVertical() {
		int width = p.getWidth();
		int height = p.getHeight();
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight()/2; j++) {
				Pixel pix = p.getPixel(i, j);
				newp.setPixel(i, j, p.getPixel(i, height-j-1));
				newp.setPixel(i, height-j-1, pix);
			}
		}
		newp.store("verticalflip.gif");
	}	
	
	public void flipHorizontal() {
		int width = p.getWidth();
		int height = p.getHeight();
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth()/2; i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j);
				newp.setPixel(i, j, p.getPixel(width-i-1, j));
				newp.setPixel(width-i-1, j, pix);
			}
		}
		newp.store("horizontalflip.gif");
	}	

	public void lighten(double amount) {
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j);
				int newr = (int)((1-amount)*pix.getRed()) + (int)(amount*255);
				int newg = (int)((1-amount)*pix.getGreen()) + (int)(amount*255);
				int newb = (int)((1-amount)*pix.getBlue()) + (int)(amount*255);
				newp.setPixel(i, j, new Pixel(newr, newg, newb));
			}
		}
		newp.store("lighter.gif");		
		
	}

	public void darken(double amount) {
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j);
				int newr = (int)((1-amount)*pix.getRed());
				int newg = (int)((1-amount)*pix.getGreen());
				int newb = (int)((1-amount)*pix.getBlue());
				newp.setPixel(i, j, new Pixel(newr, newg, newb));
			}
		}
		newp.store("darker.gif");			
	}
	
	public void scrollHorizontal(int numpixels) {
		if(numpixels > p.getWidth()) {
			System.out.println("Not able to scroll by numpixels.");
			return;
		}
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth()-numpixels; i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i+numpixels, j);
				newp.setPixel(i, j, pix);				
			}
		}
		for(int i = p.getWidth()-numpixels; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i-(p.getWidth()-numpixels), j);
				newp.setPixel(i, j, pix);				
			}
		}
		newp.store("scrollhorizontal.gif");					
	}
	
	public void scrollVertical(int numpixels) {
		if(numpixels > p.getHeight()) {
			System.out.println("Not able to scroll by numpixels.");
			return;
		}
		Picture newp = new Picture(filename);
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = 0; j < p.getHeight()-numpixels; j++) {
				Pixel pix = p.getPixel(i, j+numpixels);
				newp.setPixel(i, j, pix);				
			}
		}
		
		for(int i = 0; i < p.getWidth(); i++) {
			for(int j = p.getHeight()-numpixels; j < p.getHeight(); j++) {
				Pixel pix = p.getPixel(i, j-(p.getHeight()-numpixels));
				newp.setPixel(i, j, pix);				
			}
		}
		newp.store("scrollvertical.gif");					
	}
	
	public void swapCorners() {
		Picture newp = new Picture(filename);

		int width = p.getWidth()/2;
		int height = p.getHeight()/2;
		for(int i = 0; i < width; i++) {
			for(int j = 0; j < height; j++) {
				
				Pixel pix1 = p.getPixel(i, j);
				Pixel swaper1 = p.getPixel(width+i, height+j);
				newp.setPixel(i, j, swaper1);
				newp.setPixel(width+i, height+j, pix1);

				Pixel pix2 = p.getPixel(i+width, j);
				Pixel swaper2 = p.getPixel(i, height+j);
				newp.setPixel(i+width, j, swaper2);
				newp.setPixel(i, height+j, pix2);

			
			}
		}
		newp.store("cornerswap.gif");
		
	}
	
	public void rotate() {
		int width = p.getWidth();
		int height = p.getHeight();
		
		Picture newp = new Picture(height, width);
		
		int i = 0, j = 0;
		for(int k = 0; k < width; k++) {
			for(int l = height-1; l >= 0 ; l--) {
				Pixel pix = p.getPixel(k, l);												
				newp.setPixel(i++, j, pix);
			}
			i = 0;
			j++;
		}
		
		newp.store("rotate.gif");
	}	
	
	
	public void blur() {
		int width = p.getWidth();
		int height = p.getHeight();		
		
		Picture newp = new Picture(width, height);

		for(int i = 0; i < width; i++) {
			for(int j = 0; j < height; j++) {
				
				Pixel pix = p.getPixel(i, j);
				int reds = pix.getRed(), blues = pix.getBlue(), greens = pix.getGreen();
				int total = 1;
				
				//top left
				if(j > 0 && i > 0) {
					total++;
					Pixel neighbor = p.getPixel(i-1, j-1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
				} 
				
				//top
				if(j > 0) {
					total++;
					Pixel neighbor = p.getPixel(i, j-1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
				} 

				//top right
				if(j > 0 && i < width-1) {
					total++;
					Pixel neighbor = p.getPixel(i+1, j-1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
				} 
				
				//left
				if(i > 0) {
					total++;
					Pixel neighbor = p.getPixel(i-1, j); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();

				}
				
				//right
				if(i < width-1) {
					total++;
					Pixel neighbor = p.getPixel(i+1, j); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
				}
				
				//bottom left
				if(j < height-1 && i > 0) {
					total++;
					Pixel neighbor = p.getPixel(i-1, j+1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();

				}
				
				
				//bottom
				if(j < height-1) {
					total++;					
					Pixel neighbor = p.getPixel(i, j+1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
				}
				
				//bottom right
				if(j < height-1 && i > width-1) {
					total++;
					Pixel neighbor = p.getPixel(i+1, j+1); 
					reds += neighbor.getRed();
					blues += neighbor.getBlue();
					greens += neighbor.getGreen();
					
				}				
				newp.setPixel(i, j, new Pixel(reds/total, greens/total, blues/total));
			}
			
		}
		newp.store("blur.gif");

	}

}
