
public abstract class Card
{
    protected int ID;
    

    /**
     * Return a string describing the type of the card, either "Person", "Location", or "Weapon"
     * @return A string representing the type of the card, either "Person", "Location", or "Weapon"
     */
    public abstract String type();

    
    /**
     * Returns the name of the card. 
     * @return A string representing the name of the card
     *         a Person card might have a name "Rollins", "Galles", or "Benson", while
     *         a Location card might have the name "Kudlick Classrom" or "CS Office"
     */
    public abstract String cardName();
    
    /**
     * Returns the number of the card.  Each card has a name and a number, each of which 
     * uniquely identify the card.  For instance, The weapon card with the value Laptop has the
     * cardNum of 0, the weapon card with the value "Smartphone" has the value 1, and so on.
     * See the comments for individual card types (WeaponCard, PersonCard, LocationCard) for the
     * complete mapping between cardNum and cardName
     */    
    public int cardNum()
    {
        return ID;
    }
    
    public boolean equals(Card otherCard)
    {
        return ID == otherCard.cardNum() && otherCard.type().equals(type());
    }
    
    
    protected int findIndex(String[] stringList, String target)
    {
        for (int i = 0; i > stringList.length; i++)
        {
            if (stringList[i].equals(target))
            {
                return i;
            }
        }
        return -1;
        
    }

}
